<?php if (basename($_SERVER['PHP_SELF']) == 'members_edit.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			var mobileFormat = {
				matches: "<?php echo $mobile_matches; ?>",
				minLength: "<?php echo $mobile_min_length; ?>",
				maxLength: "<?php echo $mobile_max_length; ?>"
			};

			jQuery.validator.addMethod("validUserMobile", function(value, element) {
				var validMobile = true;
				if (value.length < mobileFormat.minLength) {
					validMobile = false;
				}

				for (var n = 0; n < value.length; n++) {
					var curMatch = mobileFormat.matches.substring(n, n + 1);
					var curField = value.substring(n, n + 1);
					if (curMatch == '9') {
						if (isNaN(curField)) {
							validMobile = false;
						}
					} else if (curMatch != '9') {
						if (curMatch != curField) {
							validMobile = false;
						}
					}
				}
				return validMobile;
			}, "<?php echo $lang['form-error-valid-mobile']; ?>");
			<?php if ($user_id_type == "mobile") { ?>
				$('#member_email').attr('placeholder', mobileFormat.matches);
			<?php } ?>
			$("#member_form").validate({
				rules: {
					member_name: {
						required: true,
						minlength: 3
					},
					<?php if ($user_id_type == "email") { ?>
						member_email: {
							required: function(element) {
								return !$("#fb_id").val();
							},
							minlength: 3,
							email: true
						},
					<?php } else { ?>
						member_email: {
							required: function(element) {
								return !$("#fb_id").val();
							},
							minlength: mobileFormat.minLength,
							validUserMobile: true
						},
					<?php } ?>
					fb_id: {
						required: function(element) {
							return !$("#member_email").val();
						},
						minlength: 3,
					}
				},
				messages: {
					<?php if ($user_id_type == "email") { ?>
						member_email: "<?php echo $lang['form-error-member-email']; ?>",
						fb_id: "<?php echo $lang['form-error-facebook-email']; ?>"
					<?php } else { ?>
						member_email: {
							required: "<?php echo $lang['form-error-mobile']; ?>",
							minlength: "<?php echo $lang['form-error-valid-mobile']; ?>"
						},
						fb_id: "<?php echo $lang['form-error-facebook-mobile']; ?>"
					<?php } ?>
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'members_add.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			var mobileFormat = {
				matches: "<?php echo $mobile_matches; ?>",
				minLength: "<?php echo $mobile_min_length; ?>",
				maxLength: "<?php echo $mobile_max_length; ?>"
			};

			jQuery.validator.addMethod("validUserMobile", function(value, element) {
				var validMobile = true;
				if (value.length < mobileFormat.minLength) {
					validMobile = false;
				}

				for (var n = 0; n < value.length; n++) {
					var curMatch = mobileFormat.matches.substring(n, n + 1);
					var curField = value.substring(n, n + 1);
					if (curMatch == '9') {
						if (isNaN(curField)) {
							validMobile = false;
						}
					} else if (curMatch != '9') {
						if (curMatch != curField) {
							validMobile = false;
						}
					}
				}
				return validMobile;
			}, "<?php echo $lang['form-error-valid-mobile']; ?>");

			<?php if ($user_id_type == "mobile") { ?>
				$('#member_email').attr('placeholder', mobileFormat.matches);
			<?php } ?>
			$("#member_form").validate({
				rules: {
					member_name: {
						required: true,
						minlength: 3
					},
					<?php if ($user_id_type == "email") { ?>
						member_email: {
							required: function(element) {
								return !$("#fb_id").val();
							},
							minlength: 3,
							email: true
						},
					<?php } else { ?>
						member_email: {
							required: function(element) {
								return !$("#fb_id").val();
							},
							minlength: mobileFormat.minLength,
							validUserMobile: true
						},
					<?php } ?>
					fb_id: {
						required: function(element) {
							return !$("#member_email").val();
						},
						minlength: 3,
					}
				},
				messages: {
					<?php if ($user_id_type == "email") { ?>
						member_email: "<?php echo $lang['form-error-member-email']; ?>",
						fb_id: "<?php echo $lang['form-error-facebook-email']; ?>"
					<?php } else { ?>
						member_email: {
							required: "<?php echo $lang['form-error-mobile']; ?>",
							minlength: "<?php echo $lang['form-error-valid-mobile']; ?>"
						},
						fb_id: "<?php echo $lang['form-error-facebook-mobile']; ?>"
					<?php } ?>
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'points_edit.php' || basename($_SERVER['PHP_SELF']) == 'points_add.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#point_form").validate({
				rules: {
					member_point: {
						required: true,
						number: true
					},
					member_chance: {
						required: true,
						number: true
					},
					member_score: {
						required: true,
						number: true
					}
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'redemption_edit.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#redemption_form").validate({
				rules: {
					reward_id: {
						required: true,
						number: true
					}
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'code_edit.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#redemption_code_form").validate({
				rules: {
					redeem_id: {
						required: true,
						number: true
					}
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'transactions_edit.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#transaction_form").validate({
				rules: {
					order_id: {
						required: true
					},
					payment_id: {
						required: true
					}
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'admin_users_add.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#admin_users_form").validate({
				errorClass: 'input-group error',
				rules: {
					user_name: {
						required: true,
						minlength: 3
					},
					passwd: {
						required: true,
						minlength: 3
					}
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'admin_users_edit.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#admin_users_form").validate({
				errorClass: 'input-group error',
				rules: {
					user_name: {
						required: true,
						minlength: 3
					}
				}
			});
		});
	</script>
<?php } ?>

<?php
if ($_SESSION['admin_type'] == 'vendor') {
	$cur_user = getAdminId();
} else {
	$cur_user = 0;
}
if (basename($_SERVER['PHP_SELF']) == 'members.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#dataTable').dataTable({
				"order": [
					[1, "desc"]
				],
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "members_response.php",
					type: "POST",
					data: function(d) {
						// You can modify the 'd' object to add custom parameters
						d.users = <?= $cur_user ?>;
					},
					error: function() {
						$("#post_list_processing").css("display", "none");
					}
				},
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "Show all"]
				],
				"dom": 'Blfrtip',
				"buttons": [{
						"extend": 'csv',
						"text": 'CSV',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'excel',
						"text": 'EXCEL',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'pdf',
						"text": 'PDF',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'print',
						"text": 'PRINT',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					}
				],
				columns: [{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return '<input type="checkbox" id="checkbox-' + data.id + '" name="checkbox-' + data.id + '" class="checkbox" value="' + data.id + '">';
						}
					},
					{
						data: "id"
					},
					{
						data: "member_name"
					},
					{
						data: "member_email"
					},
					{
						data: "fb_id"
					},
					{
						data: null,
						render: function(data, type, row) {
							return data.active_status == 1 ? 'Active' : 'In-active';
						}
					},
					<?php if ($_SESSION['admin_type'] == 'super') { ?> {
							data: null,
							sortable: false,
							render: function(data, type, row) {
								var editButtonHTML = '<a class="btn btn-primary btn-sm" href="members_edit.php?member_id=' + data.id + '&operation=edit"><span class="fa fa-edit fa-fw"></span> <?php echo $lang['button-edit']; ?></a> ';
								var removeButtonHTML = '<a class="btn btn-danger btn-sm" href="" data-toggle="modal" data-target="#confirm-delete-' + data.id + '"><span class="fa fa-trash-alt fa-fw"></span> <?php echo $lang['button-remove']; ?></a>';
								var removePopHTML = populateModal('delete', data.id, 'members_delete.php', '<?php echo $lang['modal-delete-member']; ?>', data.member_email);

								return editButtonHTML + removeButtonHTML + removePopHTML;
							}
						}
					<?php } ?>
				]
			});

			$('#check_all_top, #check_all_bottom').click(function() {
				if ($(this).is(":checked")) {
					$(".checkbox").prop("checked", true);
				} else {
					$(".checkbox").prop("checked", false);
				}
			});

			$('#update-status').on('show.bs.modal', function(event) {
				var searchIDs = [];
				$('input[class="checkbox"]:checked').each(function() {
					searchIDs.push(this.value);
				});

				$('#update-status-confirm').hide();
				$('#update-status-error').hide();

				$('#batch_id').val(searchIDs);
				$('#update_status').val($('#update_order').val());
				if (searchIDs.length > 0) {
					$('#update-status-confirm').show();
				} else {
					$('#update-status-error').show();
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'vendors.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#dataTable').dataTable({
				"order": [
					[1, "desc"]
				],
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "vendors_response.php",
					type: "POST",
					error: function() {
						$("#post_list_processing").css("display", "none");
					}
				},
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "Show all"]
				],
				"dom": 'Blfrtip',
				"buttons": [{
						"extend": 'csv',
						"text": 'CSV',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'excel',
						"text": 'EXCEL',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'pdf',
						"text": 'PDF',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'print',
						"text": 'PRINT',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					}
				],
				columns: [{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return '<input type="checkbox" id="checkbox-' + data.id + '" name="checkbox-' + data.id + '" class="checkbox" value="' + data.id + '">';
						}
					},
					{
						data: "id"
					},
					{
						data: "vendor_name"
					},
					{
						data: "vendor_email"
					},
					{
						data: "vendor_mobile"
					},
					{
						data: "vendor_balance"
					},
					{
						data: null,
						render: function(data, type, row) {
							return data.active_status == 1 ? 'Active' : 'In-active';
						}
					},
					<?php if ($_SESSION['admin_type'] == 'super') { ?> {
							data: null,
							sortable: false,
							render: function(data, type, row) {
								var editButtonHTML = '<a class="btn btn-primary btn-sm" href="vendors_edit.php?vendor_id=' + data.id + '&operation=edit"><span class="fa fa-edit fa-fw"></span> <?php echo $lang['button-edit']; ?></a> ';
								//var removeButtonHTML = '<a class="btn btn-danger btn-sm" href="" data-toggle="modal" data-target="#confirm-delete-' + data.id + '"><span class="fa fa-trash-alt fa-fw"></span> <?php echo $lang['button-remove']; ?></a>';
								//var removePopHTML = populateModal('delete', data.id, 'members_delete.php', '<?php echo $lang['modal-delete-member']; ?>', data.member_email);

								return editButtonHTML; //+ removeButtonHTML + removePopHTML;
							}
						}
					<?php } ?>
				]
			});

			$('#check_all_top, #check_all_bottom').click(function() {
				if ($(this).is(":checked")) {
					$(".checkbox").prop("checked", true);
				} else {
					$(".checkbox").prop("checked", false);
				}
			});

			$('#update-status').on('show.bs.modal', function(event) {
				var searchIDs = [];
				$('input[class="checkbox"]:checked').each(function() {
					searchIDs.push(this.value);
				});

				$('#update-status-confirm').hide();
				$('#update-status-error').hide();

				$('#batch_id').val(searchIDs);
				$('#update_status').val($('#update_order').val());
				if (searchIDs.length > 0) {
					$('#update-status-confirm').show();
				} else {
					$('#update-status-error').show();
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'points.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#dataTable').dataTable({
				"order": [
					[1, "desc"]
				],
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "points_response.php",
					type: "POST",
					error: function() {
						$("#post_list_processing").css("display", "none");
					}
				},
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "Show all"]
				],
				"dom": 'Blfrtip',
				"buttons": [{
						"extend": 'csv',
						"text": 'CSV',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'excel',
						"text": 'EXCEL',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'pdf',
						"text": 'PDF',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'print',
						"text": 'PRINT',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					}
				],
				columns: [{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return '<input type="checkbox" id="checkbox-' + data.id + '" name="checkbox-' + data.id + '" class="checkbox" value="' + data.id + '">';
						}
					},
					{
						data: "id"
					},
					{
						data: "game_type"
					},
					{
						data: "member_id"
					},
					{
						sortable: true,
						data: null,
						render: function(data, type, row) {
							return data.fb_id == '' ? data.member_email : data.fb_id;
						}
					},
					{
						data: "member_point"
					},
					{
						data: "member_chance"
					},
					{
						data: "date_updated"
					},
					<?php if ($_SESSION['admin_type'] == 'super') { ?> {
							data: null,
							sortable: false,
							render: function(data, type, row) {
								var editButtonHTML = '<a class="btn btn-primary btn-sm" href="points_edit.php?point_id=' + data.id + '&operation=edit"><span class="fa fa-edit fa-fw"></span> <?php echo $lang['button-edit']; ?></a> ';
								var removeButtonHTML = '<a class="btn btn-danger btn-sm" href="" data-toggle="modal" data-target="#confirm-delete-' + data.id + '"><span class="fa fa-trash-alt fa-fw"></span> <?php echo $lang['button-remove']; ?></a>';
								var removePopHTML = populateModal('delete', data.id, 'points_delete.php', '<?php echo $lang['modal-delete-member-point']; ?>', 'ID (' + data.id + ')');

								return editButtonHTML + removeButtonHTML + removePopHTML;
							}
						}
					<?php } ?>
				],
				initComplete: function() {
					this.api().columns([2]).every(function() {
						var column = this;
						var select = $('<select class="form-control form-control-sm" style="width:150px;"><option value=""><?php echo $lang['option-game-type']; ?></option></select>')
							.appendTo($(column.header()).empty())
							.on('change', function() {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
								column.search(val ? val : '', true, false).draw();
							});

						<?php foreach ($game_array as &$game_type_value) { ?>
							select.append('<option value="<?php echo $game_type_value; ?>"><?php echo $game_type_value; ?></option>')
						<?php } ?>
					});

					this.api().columns([5]).every(function() {
						var column = this;
						var select = $('<select class="form-control form-control-sm" style="width:150px;"><option value=""><?php echo $lang['option-all-time']; ?></option></select>')
							.appendTo($(column.header()).empty())
							.on('change', function() {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
								column.search(val ? val : '', true, false).draw();
							});

						select.append('<option value="daily"><?php echo $lang['option-daily']; ?></option>')
						select.append('<option value="weekly"><?php echo $lang['option-weekly']; ?></option>')
						select.append('<option value="monthly"><?php echo $lang['option-monthly']; ?></option>')
					});
				}
			});

			$('#check_all_top, #check_all_bottom').click(function() {
				if ($(this).is(":checked")) {
					$(".checkbox").prop("checked", true);
				} else {
					$(".checkbox").prop("checked", false);
				}
			});

			$('#update-status').on('show.bs.modal', function(event) {
				var searchIDs = [];
				$('input[class="checkbox"]:checked').each(function() {
					searchIDs.push(this.value);
				});

				$('#update-status-confirm').hide();
				$('#update-status-error').hide();

				$('#batch_id').val(searchIDs);
				$('#update_status').val($('#update_order').val());
				if (searchIDs.length > 0) {
					$('#update-status-confirm').show();
				} else {
					$('#update-status-error').show();
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'redemption.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#dataTable').dataTable({
				"order": [
					[1, "desc"]
				],
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "redemption_response.php",
					type: "POST",
					error: function() {
						$("#post_list_processing").css("display", "none");
					}
				},
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				"dom": 'Blfrtip',
				"buttons": [{
						"extend": 'csv',
						"text": 'CSV',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'excel',
						"text": 'EXCEL',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'pdf',
						"text": 'PDF',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'print',
						"text": 'PRINT',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					}
				],

				columns: [{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return '<input type="checkbox" id="redeem-' + data.id + '" name="redeem-' + data.id + '" class="checkbox" value="' + data.id + '">';
						}
					},
					{
						data: "id"
					},
					{
						data: "game_type"
					},
					{
						data: "member_id"
					},
					{
						data: null,
						sortable: true,
						render: function(data, type, row) {
							return data.fb_id == '' ? data.member_email : data.fb_id;
						}
					},
					{
						data: "reward_name"
					},
					{
						data: "date_created"
					},
					{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							if (data.redeem_status == 0) {
								var approveButtonHTML = '<a class="btn btn-primary btn-sm" href="" data-toggle="modal" data-target="#confirm-approve-' + data.id + '"><span class="fa fa-check fa-fw"></span> <?php echo $lang['button-approve']; ?></a> ';
								var rejectButtonHTML = '<a class="btn btn-secondary btn-sm" href="" data-toggle="modal" data-target="#confirm-reject-' + data.id + '"><span class="fa fa-times fa-fw"></span> <?php echo $lang['button-reject']; ?></a>';
								var approvePopHTML = populateModal('approve', data.id, 'redemption_update.php', '<?php echo $lang['modal-approve-item']; ?>', 'ID (' + data.id + ')');
								var rejectPopHTML = populateModal('reject', data.id, 'redemption_update.php', '<?php echo $lang['modal-reject-item']; ?>', 'ID (' + data.id + ')');

								return approveButtonHTML + rejectPopHTML + rejectButtonHTML + approvePopHTML;
							} else if (data.redeem_status == 1) {
								return 'Rejected';
							} else if (data.redeem_status == 2) {
								return 'Complete';
							}
						}
					},
					<?php if ($_SESSION['admin_type'] == 'super') { ?> {
							data: null,
							sortable: false,
							render: function(data, type, row) {
								var editButtonHTML = '<a class="btn btn-primary btn-sm" href="redemption_edit.php?reward_id=' + data.id + '&operation=edit"><span class="fa fa-edit fa-fw"></span> <?php echo $lang['button-edit']; ?></a> ';
								var removeButtonHTML = '<a class="btn btn-danger btn-sm" href="" data-toggle="modal" data-target="#confirm-delete-' + data.id + '"><span class="fa fa-trash-alt fa-fw"></span> <?php echo $lang['button-remove']; ?></a>';
								var removePopHTML = populateModal('delete', data.id, 'redemption_delete.php', '<?php echo $lang['modal-delete-user-item']; ?>', data.reward_name);

								return editButtonHTML + removeButtonHTML + removePopHTML;
							}
						}
					<?php } ?>
				],
				initComplete: function() {
					this.api().columns([2]).every(function() {
						var column = this;
						var select = $('<select class="form-control form-control-sm" style="width:150px;"><option value=""><?php echo $lang['option-game-type']; ?></option></select>')
							.appendTo($(column.header()).empty())
							.on('change', function() {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
								column.search(val ? val : '', true, false).draw();
							});

						<?php foreach ($game_array as &$game_type_value) { ?>
							select.append('<option value="<?php echo $game_type_value; ?>"><?php echo $game_type_value; ?></option>')
						<?php } ?>
					});
				}
			});

			$('#check_all_top, #check_all_bottom').click(function() {
				if ($(this).is(":checked")) {
					$(".checkbox").prop("checked", true);
				} else {
					$(".checkbox").prop("checked", false);
				}
			});

			$('#update-status').on('show.bs.modal', function(event) {
				var searchIDs = [];
				$('input[class="checkbox"]:checked').each(function() {
					searchIDs.push(this.value);
				});

				$('#update-status-confirm').hide();
				$('#update-status-error').hide();

				$('#batch_id').val(searchIDs);
				$('#update_status').val($('#update_order').val());
				if (searchIDs.length > 0) {
					$('#update-status-confirm').show();
				} else {
					$('#update-status-error').show();
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'code.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#dataTable').dataTable({
				"order": [
					[1, "desc"]
				],
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "code_response.php",
					type: "POST",
					error: function() {
						$("#post_list_processing").css("display", "none");
					}
				},
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				"dom": 'Blfrtip',
				"buttons": [{
						"extend": 'csv',
						"text": 'CSV',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'excel',
						"text": 'EXCEL',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'pdf',
						"text": 'PDF',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'print',
						"text": 'PRINT',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					}
				],

				columns: [{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return '<input type="checkbox" id="checkbox-' + data.id + '" name="checkbox-' + data.id + '" class="checkbox" value="' + data.id + '">';
						}
					},
					{
						data: "id"
					},
					{
						data: "game_type"
					},
					{
						data: "member_id"
					},
					{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return data.fb_id == '' ? data.member_email : data.fb_id;
						}
					},
					{
						data: "redeem_name"
					},
					{
						data: "date_created"
					},
					<?php if ($_SESSION['admin_type'] == 'super') { ?> {
							data: null,
							sortable: false,
							render: function(data, type, row) {
								var editButtonHTML = '<a class="btn btn-primary btn-sm" href="code_edit.php?redeem_id=' + data.id + '&operation=edit"><span class="fa fa-edit fa-fw"></span> <?php echo $lang['button-edit']; ?></a> ';
								var removeButtonHTML = '<a class="btn btn-danger btn-sm" href="" data-toggle="modal" data-target="#confirm-delete-' + data.id + '"><span class="fa fa-trash-alt fa-fw"></span> <?php echo $lang['button-remove']; ?></a>';
								var removePopHTML = populateModal('delete', data.id, 'code_delete.php', '<?php echo $lang['modal-delete-user-code']; ?>', data.redeem_name);

								return editButtonHTML + removeButtonHTML + removePopHTML;
							}
						}
					<?php } ?>
				],
				initComplete: function() {
					this.api().columns([2]).every(function() {
						var column = this;
						var select = $('<select class="form-control form-control-sm" style="width:150px;"><option value=""><?php echo $lang['option-game-type']; ?></option></select>')
							.appendTo($(column.header()).empty())
							.on('change', function() {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
								column.search(val ? val : '', true, false).draw();
							});

						<?php foreach ($game_array as &$game_type_value) { ?>
							select.append('<option value="<?php echo $game_type_value; ?>"><?php echo $game_type_value; ?></option>')
						<?php } ?>
					});
				}
			});

			$('#check_all_top, #check_all_bottom').click(function() {
				if ($(this).is(":checked")) {
					$(".checkbox").prop("checked", true);
				} else {
					$(".checkbox").prop("checked", false);
				}
			});

			$('#update-status').on('show.bs.modal', function(event) {
				var searchIDs = [];
				$('input[class="checkbox"]:checked').each(function() {
					searchIDs.push(this.value);
				});

				$('#update-status-confirm').hide();
				$('#update-status-error').hide();

				$('#batch_id').val(searchIDs);
				$('#update_status').val($('#update_order').val());
				if (searchIDs.length > 0) {
					$('#update-status-confirm').show();
				} else {
					$('#update-status-error').show();
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'transactions.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#dataTable').dataTable({
				"order": [
					[1, "desc"]
				],
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "transactions_response.php",
					type: "POST",
					error: function() {
						$("#post_list_processing").css("display", "none");
					}
				},
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				"dom": 'Blfrtip',
				"buttons": [{
						"extend": 'csv',
						"text": 'CSV',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'excel',
						"text": 'EXCEL',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'pdf',
						"text": 'PDF',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'print',
						"text": 'PRINT',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					}
				],
				columns: [{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return '<input type="checkbox" id="checkbox-' + data.id + '" name="checkbox-' + data.id + '" class="checkbox" value="' + data.id + '">';
						}
					},
					{
						data: "id"
					},
					{
						data: "game_type"
					},
					{
						data: "member_id"
					},
					{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return data.fb_id == '' ? data.member_email : data.fb_id;
						}
					},
					{
						data: "order_id"
					},
					{
						data: "payment_id"
					},
					{
						data: null,
						render: function(data, type, row) {
							return data.payment_status == 0 ? 'Pending' : 'Complete';
						}
					},
					{
						data: "date_created"
					},
					<?php if ($_SESSION['admin_type'] == 'super') { ?> {
							data: null,
							sortable: false,
							render: function(data, type, row) {
								var editButtonHTML = '<a class="btn btn-primary btn-sm" href="transactions_edit.php?transaction_id=' + data.id + '&operation=edit"><span class="fa fa-edit fa-fw"></span> <?php echo $lang['button-edit']; ?></a> ';
								var removeButtonHTML = '<a class="btn btn-danger btn-sm" href="" data-toggle="modal" data-target="#confirm-delete-' + data.id + '"><span class="fa fa-trash-alt fa-fw"></span> <?php echo $lang['button-remove']; ?></a>';
								var removePopHTML = populateModal('delete', data.id, 'transactions_delete.php', '<?php echo $lang['modal-delete-transaction']; ?>', 'ID (' + data.id + ')');

								return editButtonHTML + removeButtonHTML + removePopHTML;
							}
						}
					<?php } ?>
				],
				initComplete: function() {
					this.api().columns([2]).every(function() {
						var column = this;
						var select = $('<select class="form-control form-control-sm" style="width:150px;"><option value=""><?php echo $lang['option-game-type']; ?></option></select>')
							.appendTo($(column.header()).empty())
							.on('change', function() {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
								column.search(val ? val : '', true, false).draw();
							});

						<?php foreach ($game_array as &$game_type_value) { ?>
							select.append('<option value="<?php echo $game_type_value; ?>"><?php echo $game_type_value; ?></option>')
						<?php } ?>
					});
				}

			});

			$('#check_all_top, #check_all_bottom').click(function() {
				if ($(this).is(":checked")) {
					$(".checkbox").prop("checked", true);
				} else {
					$(".checkbox").prop("checked", false);
				}
			});

			$('#update-status').on('show.bs.modal', function(event) {
				var searchIDs = [];
				$('input[class="checkbox"]:checked').each(function() {
					searchIDs.push(this.value);
				});

				$('#update-status-confirm').hide();
				$('#update-status-error').hide();

				$('#batch_id').val(searchIDs);
				$('#update_status').val($('#update_order').val());
				if (searchIDs.length > 0) {
					$('#update-status-confirm').show();
				} else {
					$('#update-status-error').show();
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'products.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#dataTable').dataTable({
				"order": [
					[1, "desc"]
				],
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "products_response.php",
					type: "POST",
					error: function() {
						$("#post_list_processing").css("display", "none");
					}
				},
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				"dom": 'Blfrtip',
				"buttons": [{
						"extend": 'csv',
						"text": 'CSV',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'excel',
						"text": 'EXCEL',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'pdf',
						"text": 'PDF',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'print',
						"text": 'PRINT',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					}
				],
				columns: [{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return '<input type="checkbox" id="product-' + data.id + '" name="product-' + data.id + '" class="checkbox" value="' + data.id + '">';
						}
					},
					{
						data: "id"
					},
					{
						data: "game_type"
					},
					{
						data: "order_id"
					},
					{
						data: "order_name"
					},
					{
						data: "order_price"
					},
					{
						data: "order_points"
					},
					{
						data: "order_chances"
					},
					<?php if ($_SESSION['admin_type'] == 'super') { ?> {
							data: null,
							sortable: false,
							render: function(data, type, row) {
								var editButtonHTML = '<a class="btn btn-primary btn-sm" href="products_edit.php?product_id=' + data.id + '&operation=edit"><span class="fa fa-edit fa-fw"></span> <?php echo $lang['button-edit']; ?></a> ';
								var removeButtonHTML = '<a class="btn btn-danger btn-sm" href="" data-toggle="modal" data-target="#confirm-delete-' + data.id + '"><span class="fa fa-trash-alt fa-fw"></span> <?php echo $lang['button-remove']; ?></a>';
								var removePopHTML = populateModal('delete', data.id, 'products_delete.php', '<?php echo $lang['modal-delete-product']; ?>', data.order_name);

								return editButtonHTML + removeButtonHTML + removePopHTML;
							}
						}
					<?php } ?>
				],
				initComplete: function() {
					/*this.api().columns([2]).every( function () {
					var column = this;
					var select = $('<select class="form-control form-control-sm" style="width:150px;"><option value=""><?php echo $lang['option-game-type']; ?></option></select>')
					.appendTo( $(column.header()).empty() )
					.on( 'change', function () {
						var val = $.fn.dataTable.util.escapeRegex(
							$(this).val()
						);
						column.search( val ? val : '', true, false ).draw();
					});

					<?php foreach ($game_array as &$game_type_value) { ?>
					select.append( '<option value="<?php echo $game_type_value; ?>"><?php echo $game_type_value; ?></option>')
					<?php } ?>
				});*/
				}


			});

			$('#check_all_top, #check_all_bottom').click(function() {
				if ($(this).is(":checked")) {
					$(".checkbox").prop("checked", true);
				} else {
					$(".checkbox").prop("checked", false);
				}
			});

			$('#update-status').on('show.bs.modal', function(event) {
				var searchIDs = [];
				$('input[class="checkbox"]:checked').each(function() {
					searchIDs.push(this.value);
				});

				$('#update-status-confirm').hide();
				$('#update-status-error').hide();

				$('#batch_id').val(searchIDs);
				$('#update_status').val($('#update_order').val());
				if (searchIDs.length > 0) {
					$('#update-status-confirm').show();
				} else {
					$('#update-status-error').show();
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'rewards.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#dataTable').dataTable({
				"order": [
					[1, "desc"]
				],
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "rewards_response.php",
					type: "POST",
					error: function() {
						$("#post_list_processing").css("display", "none");
					}
				},
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				"dom": 'Blfrtip',
				"buttons": [{
						"extend": 'csv',
						"text": 'CSV',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'excel',
						"text": 'EXCEL',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'pdf',
						"text": 'PDF',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {

							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'print',
						"text": 'PRINT',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					}
				],
				columns: [{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return '<input type="checkbox" id="checkbox-' + data.id + '" name="checkbox-' + data.id + '" class="checkbox" value="' + data.id + '">';
						}
					},
					{
						data: "id"
					},
					{
						data: "game_type"
					},
					{
						data: null,
						render: function(data, type, row) {
							return '<img class="thumbColumn" src="' + data.reward_image + '" />';
						}
					},
					{
						data: "reward_name"
					},
					{
						data: "reward_points"
					},
					<?php if ($_SESSION['admin_type'] == 'super') { ?> {
							data: null,
							sortable: false,
							render: function(data, type, row) {
								var editButtonHTML = '<a class="btn btn-primary btn-sm" href="rewards_edit.php?reward_id=' + data.id + '&operation=edit"><span class="fa fa-edit fa-fw"></span> <?php echo $lang['button-edit']; ?></a> ';
								var removeButtonHTML = '<a class="btn btn-danger btn-sm" href="" data-toggle="modal" data-target="#confirm-delete-' + data.id + '"><span class="fa fa-trash-alt fa-fw"></span> <?php echo $lang['button-remove']; ?></a>';
								var removePopHTML = populateModal('delete', data.id, 'rewards_delete.php', '<?php echo $lang['modal-delete-reward-item']; ?>', data.reward_name);

								return editButtonHTML + removeButtonHTML + removePopHTML;
							}
						}
					<?php } ?>
				],
				initComplete: function() {
					this.api().columns([2]).every(function() {
						var column = this;
						var select = $('<select class="form-control form-control-sm" style="width:150px;"><option value=""><?php echo $lang['option-game-type']; ?></option></select>')
							.appendTo($(column.header()).empty())
							.on('change', function() {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
								column.search(val ? val : '', true, false).draw();
							});

						<?php foreach ($game_array as &$game_type_value) { ?>
							select.append('<option value="<?php echo $game_type_value; ?>"><?php echo $game_type_value; ?></option>')
						<?php } ?>
					});
				}
			});

			$('#check_all_top, #check_all_bottom').click(function() {
				if ($(this).is(":checked")) {
					$(".checkbox").prop("checked", true);
				} else {
					$(".checkbox").prop("checked", false);
				}
			});

			$('#update-status').on('show.bs.modal', function(event) {
				var searchIDs = [];
				$('input[class="checkbox"]:checked').each(function() {
					searchIDs.push(this.value);
				});

				$('#update-status-confirm').hide();
				$('#update-status-error').hide();

				$('#batch_id').val(searchIDs);
				$('#update_status').val($('#update_order').val());
				if (searchIDs.length > 0) {
					$('#update-status-confirm').show();
				} else {
					$('#update-status-error').show();
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'rewards_edit.php' || basename($_SERVER['PHP_SELF']) == 'rewards_add.php') {
	include_once 'includes/image.php'; ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#rewards_form").validate({
				rules: {
					reward_name: {
						required: true,
						minlength: 3
					},
					reward_points: {
						required: true,
						number: true
					},
					reward_for_chances: {
						required: true,
						number: true
					}
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'redeem.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#dataTable').dataTable({
				"order": [
					[1, "desc"]
				],
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "redeem_response.php",
					type: "POST",
					error: function() {
						$("#post_list_processing").css("display", "none");
					}
				},
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				"dom": 'Blfrtip',
				"buttons": [{
						"extend": 'csv',
						"text": 'CSV',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'excel',
						"text": 'EXCEL',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'pdf',
						"text": 'PDF',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'print',
						"text": 'PRINT',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					}
				],
				columns: [{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return '<input type="checkbox" id="checkbox-' + data.id + '" name="checkbox-' + data.id + '" class="checkbox" value="' + data.id + '">';
						}
					},
					{
						data: "id"
					},
					{
						data: "game_type"
					},
					{
						data: "redeem_code"
					},
					{
						data: "redeem_name"
					},
					{
						data: "redeem_total"
					},
					{
						data: null,
						render: function(data, type, row) {
							if (data.redeem_type == 0) {
								return 'NO LIMIT';
							} else if (data.redeem_type == 1) {
								return 'ONE TIME';
							} else if (data.redeem_type == 2) {
								return 'DAILY';
							} else if (data.redeem_type == 3) {
								return 'WEEKLY';
							} else if (data.redeem_type == 4) {
								return 'MONTHLY';
							}
						}
					},
					{
						data: "expire_date"
					},
					<?php if ($_SESSION['admin_type'] == 'super') { ?> {
							data: null,
							sortable: false,
							render: function(data, type, row) {
								var editButtonHTML = '<a class="btn btn-primary btn-sm" href="redeem_edit.php?redeem_id=' + data.id + '&operation=edit"><span class="fa fa-edit fa-fw"></span> <?php echo $lang['button-edit']; ?></a> ';
								var removeButtonHTML = '<a class="btn btn-danger btn-sm" href="" data-toggle="modal" data-target="#confirm-delete-' + data.id + '"><span class="fa fa-trash-alt fa-fw"></span> <?php echo $lang['button-remove']; ?></a>';
								var removePopHTML = populateModal('delete', data.id, 'redeem_delete.php', '<?php echo $lang['modal-delete-redeem-code']; ?>', data.redeem_name);

								return editButtonHTML + removeButtonHTML + removePopHTML;
							}
						}
					<?php } ?>
				],
				initComplete: function() {
					this.api().columns([2]).every(function() {
						var column = this;
						var select = $('<select class="form-control form-control-sm" style="width:150px;"><option value=""><?php echo $lang['option-game-type']; ?></option></select>')
							.appendTo($(column.header()).empty())
							.on('change', function() {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
								column.search(val ? val : '', true, false).draw();
							});

						<?php foreach ($game_array as &$game_type_value) { ?>
							select.append('<option value="<?php echo $game_type_value; ?>"><?php echo $game_type_value; ?></option>')
						<?php } ?>
					});
				}


			});

			$('#check_all_top, #check_all_bottom').click(function() {
				if ($(this).is(":checked")) {
					$(".checkbox").prop("checked", true);
				} else {
					$(".checkbox").prop("checked", false);
				}
			});

			$('#update-status').on('show.bs.modal', function(event) {
				var searchIDs = [];
				$('input[class="checkbox"]:checked').each(function() {
					searchIDs.push(this.value);
				});

				$('#update-status-confirm').hide();
				$('#update-status-error').hide();

				$('#batch_id').val(searchIDs);
				$('#update_status').val($('#update_order').val());
				if (searchIDs.length > 0) {
					$('#update-status-confirm').show();
				} else {
					$('#update-status-error').show();
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'redeem_edit.php' || basename($_SERVER['PHP_SELF']) == 'redeem_add.php') {
	include_once 'includes/image.php';
} ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'redeem_edit.php' || basename($_SERVER['PHP_SELF']) == 'redeem_add.php') {  ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#expire_date').datepicker({
				autoclose: true,
				todayHighlight: true,
				startDate: '+1d',
				format: 'dd-mm-yyyy'
			});

			$("#redeem_form").validate({
				rules: {
					redeem_code: {
						required: true,
						minlength: 3
					},
					redeem_name: {
						required: true,
						minlength: 3
					},
					redeem_total: {
						required: true,
						number: true
					},
					redeem_for_chances: {
						required: true,
						number: true
					},
					redeem_for_points: {
						required: true,
						number: true
					},
					expire_date: {
						required: true
					}
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'products_edit.php' || basename($_SERVER['PHP_SELF']) == 'products_add.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#product_form").validate({
				rules: {
					order_id: {
						required: true,
						minlength: 3
					},
					order_name: {
						required: true,
						minlength: 3
					}
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'admin_users.php' && $_SESSION['admin_type'] == 'super') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#dataTable').dataTable({
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "admin_response.php",
					type: "POST",
					error: function() {
						$("#post_list_processing").css("display", "none");
					}
				},
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				"dom": 'Blfrtip',
				"buttons": [{
						"extend": 'csv',
						"text": 'CSV',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'excel',
						"text": 'EXCEL',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'pdf',
						"text": 'PDF',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'print',
						"text": 'PRINT',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					}
				],
				columns: [{
						data: "id"
					},
					{
						data: "user_name"
					},
					{
						data: "admin_type"
					},
					<?php if ($_SESSION['admin_type'] == 'super') { ?> {
							data: null,
							sortable: false,
							render: function(data, type, row) {
								var editButtonHTML = '<a class="btn btn-primary btn-sm" href="admin_users_edit.php?admin_user_id=' + data.id + '&operation=edit"><span class="fa fa-edit fa-fw"></span> <?php echo $lang['button-edit']; ?></a> ';
								var removeButtonHTML = '<a class="btn btn-danger btn-sm" href="" data-toggle="modal" data-target="#confirm-delete-' + data.id + '"><span class="fa fa-trash-alt fa-fw"></span> <?php echo $lang['button-remove']; ?></a>';
								var removePopHTML = populateModal('delete', data.id, 'admin_users_delete.php', '<?php echo $lang['modal-delete-admin']; ?>', data.user_name);

								return editButtonHTML + removeButtonHTML + removePopHTML;
							}
						}
					<?php } ?>
				]
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'assets.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#dataTable').dataTable({
				"order": [
					[1, "desc"]
				],
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "assets_response.php",
					type: "POST",
					error: function() {
						$("#post_list_processing").css("display", "none");
					}
				},
				columns: [{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return '<input type="checkbox" id="checkbox-' + data.id + '" name="checkbox-' + data.id + '" class="checkbox" value="' + data.id + '">';
						}
					},
					{
						data: "id"
					},
					{
						data: null,
						render: function(data, type, row) {
							return '<img src="' + data.image + '" />';
						}
					},
					{
						data: "image_path",
						sortable: false
					},
					<?php if ($_SESSION['admin_type'] == 'super') { ?> {
							data: null,
							sortable: false,
							render: function(data, type, row) {
								var copyButtonHTML = '<button class="btn btn-success btn-sm btn-copy-path" data-copy-path=' + data.image_path + ' onclick="copyPathFunc(\'' + data.image_path + '\')"><span class="fa fa-copy fa-fw"></span> <?php echo $lang['button-copy']; ?></button> ';
								var editButtonHTML = '<a class="btn btn-primary btn-sm" href="assets_edit.php?asset_id=' + data.id + '&operation=edit"><span class="fa fa-edit fa-fw"></span> <?php echo $lang['button-edit']; ?></a> ';
								var removeButtonHTML = '<a class="btn btn-danger btn-sm" href="" data-toggle="modal" data-target="#confirm-delete-' + data.id + '"><span class="fa fa-trash-alt fa-fw"></span> <?php echo $lang['button-remove']; ?></a>';
								var removePopHTML = populateModal('delete', data.id, 'assets_delete.php', '<?php echo $lang['modal-delete-asset']; ?>', data.image);

								return copyButtonHTML + editButtonHTML + removeButtonHTML + removePopHTML;
							}
						}
					<?php } ?>
				]
			});

			$('#check_all_top, #check_all_bottom').click(function() {
				if ($(this).is(":checked")) {
					$(".checkbox").prop("checked", true);
				} else {
					$(".checkbox").prop("checked", false);
				}
			});

			$('#update-status').on('show.bs.modal', function(event) {
				var searchIDs = [];
				$('input[class="checkbox"]:checked').each(function() {
					searchIDs.push(this.value);
				});

				$('#update-status-confirm').hide();
				$('#update-status-error').hide();

				$('#batch_id').val(searchIDs);
				$('#update_status').val($('#update_order').val());
				if (searchIDs.length > 0) {
					$('#update-status-confirm').show();
				} else {
					$('#update-status-error').show();
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'assets_edit.php' || basename($_SERVER['PHP_SELF']) == 'assets_add.php') {
	include_once 'includes/image.php';
} ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'gamesettings.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#dataTable').dataTable({
				"order": [
					[1, "desc"]
				],
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "gamesettings_response.php",
					type: "POST",
					error: function() {
						$("#post_list_processing").css("display", "none");
					}
				},
				columns: [{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return '<input type="checkbox" id="checkbox-' + data.id + '" name="checkbox-' + data.id + '" class="checkbox" value="' + data.id + '">';
						}
					},
					{
						data: "id"
					},
					{
						data: "game_type"
					},
					{
						data: "setting_name"
					},
					{
						data: "setting_value"
					},
					{
						data: null,
						render: function(data, type, row) {
							return data.setting_status == 1 ? 'Active' : 'In-Active';
						}
					},
					<?php if ($_SESSION['admin_type'] == 'super') { ?> {
							data: null,
							sortable: false,
							render: function(data, type, row) {
								var editButtonHTML = '<a class="btn btn-primary btn-sm" href="gamesettings_edit.php?gamesetting_id=' + data.id + '&operation=edit"><span class="fa fa-edit fa-fw"></span> <?php echo $lang['button-edit']; ?></a> ';
								var removeButtonHTML = '<a class="btn btn-danger btn-sm" href="" data-toggle="modal" data-target="#confirm-delete-' + data.id + '"><span class="fa fa-trash-alt fa-fw"></span> <?php echo $lang['button-remove']; ?></a>';
								var removePopHTML = populateModal('delete', data.id, 'gamesettings_delete.php', '<?php echo $lang['modal-delete-asset']; ?>', data.setting_name);

								return editButtonHTML + removeButtonHTML + removePopHTML;
							}
						}
					<?php } ?>
				],
				initComplete: function() {
					this.api().columns([2]).every(function() {
						var column = this;
						var select = $('<select class="form-control form-control-sm" style="width:150px;"><option value=""><?php echo $lang['option-game-type']; ?></option></select>')
							.appendTo($(column.header()).empty())
							.on('change', function() {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
								column.search(val ? val : '', true, false).draw();
							});

						<?php foreach ($game_array as &$game_type_value) { ?>
							select.append('<option value="<?php echo $game_type_value; ?>"><?php echo $game_type_value; ?></option>')
						<?php } ?>
					});
				}


			});

			$('#check_all_top, #check_all_bottom').click(function() {
				if ($(this).is(":checked")) {
					$(".checkbox").prop("checked", true);
				} else {
					$(".checkbox").prop("checked", false);
				}
			});

			$('#update-status').on('show.bs.modal', function(event) {
				var searchIDs = [];
				$('input[class="checkbox"]:checked').each(function() {
					searchIDs.push(this.value);
				});

				$('#update-status-confirm').hide();
				$('#update-status-error').hide();

				$('#batch_id').val(searchIDs);
				$('#update_status').val($('#update_order').val());
				if (searchIDs.length > 0) {
					$('#update-status-confirm').show();
				} else {
					$('#update-status-error').show();
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'gamesettings_edit.php' || basename($_SERVER['PHP_SELF']) == 'gamesettings_add.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('.btn-convert-json').click(function() {
				var returnJSON = convertJSON($('#setting_value').val());
				$('#setting_value').val(returnJSON);
			});

			$("#gamesettings_form").validate({
				rules: {
					setting_name: {
						required: true
					},
					setting_value: {
						required: true
					}
				}
			});
		});
	</script>
<?php } ?>

<?php if (basename($_SERVER['PHP_SELF']) == 'gamelogs.php') { ?>
	<script type="text/javascript">
		$(document).ready(function() {
			$('#dataTable').dataTable({
				"order": [
					[6, "desc"]
				],
				"bProcessing": true,
				"serverSide": true,
				"ajax": {
					url: "gamelogs_response.php",
					type: "POST",
					error: function() {
						$("#post_list_processing").css("display", "none");
					}
				},
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "Show all"]
				],
				"dom": 'Blfrtip',
				"buttons": [{
						"extend": 'csv',
						"text": 'CSV',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'excel',
						"text": 'EXCEL',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'pdf',
						"text": 'PDF',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					},
					{
						"extend": 'print',
						"text": 'PRINT',
						"className": 'btn btn-secondary btn-sm',
						exportOptions: {
							columns: ':not(.notexport)'
						}
					}
				],
				columns: [{
						data: null,
						sortable: false,
						render: function(data, type, row) {
							return '<input type="checkbox" id="checkbox-' + data.id + '" name="checkbox-' + data.id + '" class="checkbox" value="' + data.id + '">';
						}
					},
					{
						data: "id"
					},
					{
						data: "game_type"
					},
					{
						data: "member_id"
					},
					{
						sortable: true,
						data: null,
						render: function(data, type, row) {
							return data.fb_id == '' ? data.member_email : data.fb_id;
						}
					},
					{
						sortable: true,
						data: null,
						render: function(data, type, row) {
							return '<textarea class="json" readonly style="width:300px; resize:none; border:none; overflow:hidden;">' + convertJSON(data.game_data) + '</textarea>';
						}
					},
					{
						data: "date"
					},
					<?php if ($_SESSION['admin_type'] == 'super') { ?> {
							data: null,
							sortable: false,
							render: function(data, type, row) {
								var removeButtonHTML = '<a class="btn btn-danger btn-sm" href="" data-toggle="modal" data-target="#confirm-delete-' + data.id + '"><span class="fa fa-trash-alt fa-fw"></span> <?php echo $lang['button-remove']; ?></a>';
								var removePopHTML = populateModal('delete', data.id, 'gamelogs_delete.php', '<?php echo $lang['modal-delete-log']; ?>', 'ID (' + data.id + ')');

								return removeButtonHTML + removePopHTML;
							}
						}
					<?php } ?>
				],
				initComplete: function() {
					this.api().columns([2]).every(function() {
						var column = this;
						var select = $('<select class="form-control form-control-sm" style="width:150px;"><option value=""><?php echo $lang['option-game-type']; ?></option></select>')
							.appendTo($(column.header()).empty())
							.on('change', function() {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
								column.search(val ? val : '', true, false).draw();
							});

						<?php foreach ($game_array as &$game_type_value) { ?>
							select.append('<option value="<?php echo $game_type_value; ?>"><?php echo $game_type_value; ?></option>')
						<?php } ?>
					});
				},
				"drawCallback": function(settings) {
					function resizeTextArea($element) {
						$element.height($element[0].scrollHeight);
					}

					$('.json').each(function(index) {
						resizeTextArea($(this));
					});
				}
			});

			$('#check_all_top, #check_all_bottom').click(function() {
				if ($(this).is(":checked")) {
					$(".checkbox").prop("checked", true);
				} else {
					$(".checkbox").prop("checked", false);
				}
			});

			$('#update-status').on('show.bs.modal', function(event) {
				var searchIDs = [];
				$('input[class="checkbox"]:checked').each(function() {
					searchIDs.push(this.value);
				});

				$('#update-status-confirm').hide();
				$('#update-status-error').hide();

				$('#batch_id').val(searchIDs);
				$('#update_status').val($('#update_order').val());
				if (searchIDs.length > 0) {
					$('#update-status-confirm').show();
				} else {
					$('#update-status-error').show();
				}
			});
		});
	</script>
<?php } ?>