<?php
session_start();
require_once './config/config.php';
require_once './language/language.php';
require_once 'includes/auth_validate.php';


//Get Dashboard information
$db->get($table_member);
$numMembers = $db->count;

$db->get($table_redemption);
$numRedeem = $db->count;

$db->get($table_redemption_code);
$numRedeemCode = $db->count;

$db->get($table_transaction);
$numTransactions = $db->count;

include_once('includes/header.php');
?>

<main>
	<div class="container-fluid">
		<h1 class="mt-4"><?php echo $lang['nav-dashboard']; ?></h1>
		<ol class="breadcrumb mb-4">
			<li class="breadcrumb-item active"><?php echo $lang['nav-dashboard']; ?></li>
		</ol>
		<div class="row">
			<div class="col-xl-3 col-md-6">
				<div class="card bg-primary text-white mb-4">
					<div class="card-body">
						<div class="row">
							<div class="col col-xs-3">
								<i class="fa fa-user fa-4x"></i>
							</div>
							<div class="col col-xs-9 text-right">
								<div class="h1"><?php echo $numMembers; ?></div>
								<div><?php echo $lang['home-members']; ?></div>
							</div>
						</div>
					</div>
					<div class="card-footer d-flex align-items-center justify-content-between">
						<a class="small text-white stretched-link" href="members.php"><?php echo $lang['button-view-details']; ?></a>
						<div class="small text-white"><svg class="svg-inline--fa fa-angle-right fa-w-8" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="angle-right" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512" data-fa-i2svg="">
								<path fill="currentColor" d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z"></path>
							</svg><!-- <i class="fas fa-angle-right"></i> --></div>
					</div>
				</div>
			</div>
			<div class="col-xl-3 col-md-6">
				<div class="card bg-secondary text-white mb-4">
					<div class="card-body">
						<div class="row">
							<div class="col col-xs-3">
								<i class="fa fa-trophy fa-4x"></i>
							</div>
							<div class="col col-xs-9 text-right">
								<div class="h1"><?php echo $numRedeem; ?></div>
								<div><?php echo $lang['home-redemption']; ?></div>
							</div>
						</div>
					</div>
					<div class="card-footer d-flex align-items-center justify-content-between">
						<a class="small text-white stretched-link" href="redemption.php"><?php echo $lang['button-view-details']; ?></a>
						<div class="small text-white"><svg class="svg-inline--fa fa-angle-right fa-w-8" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="angle-right" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512" data-fa-i2svg="">
								<path fill="currentColor" d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z"></path>
							</svg><!-- <i class="fas fa-angle-right"></i> --></div>
					</div>
				</div>
			</div>
			<div class="col-xl-3 col-md-6">
				<div class="card bg-secondary text-white mb-4">
					<div class="card-body">
						<div class="row">
							<div class="col col-xs-3">
								<i class="fa fa-trophy fa-4x"></i>
							</div>
							<div class="col col-xs-9 text-right">
								<div class="h1"><?php echo $numRedeemCode; ?></div>
								<div><?php echo $lang['home-code']; ?></div>
							</div>
						</div>
					</div>
					<div class="card-footer d-flex align-items-center justify-content-between">
						<a class="small text-white stretched-link" href="code.php"><?php echo $lang['button-view-details']; ?></a>
						<div class="small text-white"><svg class="svg-inline--fa fa-angle-right fa-w-8" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="angle-right" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512" data-fa-i2svg="">
								<path fill="currentColor" d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z"></path>
							</svg><!-- <i class="fas fa-angle-right"></i> --></div>
					</div>
				</div>
			</div>
			<div class="col-xl-3 col-md-6">
				<div class="card bg-secondary text-white mb-4">
					<div class="card-body">
						<div class="row">
							<div class="col col-xs-3">
								<i class="fa fa-credit-card fa-4x"></i>
							</div>
							<div class="col col-xs-9 text-right">
								<div class="h1"><?php echo $numTransactions; ?></div>
								<div><?php echo $lang['home-transactions']; ?></div>
							</div>
						</div>
					</div>
					<div class="card-footer d-flex align-items-center justify-content-between">
						<a class="small text-white stretched-link" href="transactions.php"><?php echo $lang['button-view-details']; ?></a>
						<div class="small text-white"><svg class="svg-inline--fa fa-angle-right fa-w-8" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="angle-right" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512" data-fa-i2svg="">
								<path fill="currentColor" d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z"></path>
							</svg><!-- <i class="fas fa-angle-right"></i> --></div>
					</div>
				</div>
			</div>
		</div>
	</div>
</main>

<?php include_once('includes/footer.php'); ?>