<?php
session_start();
require_once './config/config.php';
require_once './language/language.php';
require_once 'includes/auth_validate.php';

if($_SESSION['admin_type']!='super'){
	$_SESSION['failure'] = $lang['permission-denied-log'];
	header('location: members.php');
	exit;
}

// Sanitize if you want
$member_id = filter_input(INPUT_GET, 'member_id', FILTER_VALIDATE_INT);
$operation = filter_input(INPUT_GET, 'operation',FILTER_SANITIZE_SPECIAL_CHARS ); 
($operation == 'edit') ? $edit = true : $edit = false;
//Handle update request 
if ($_SERVER['REQUEST_METHOD'] == 'POST') 
{
    $member_id = filter_input(INPUT_GET, 'member_id', FILTER_VALIDATE_INT);

    $data_to_update = filter_input_array(INPUT_POST);
	
	if (empty($data_to_update['member_password'])){
		unset($data_to_update['member_password']);		
	}else{
		$data_to_update['member_password']=md5($data_to_update['member_password']);	
	}
    
    $db->where('id',$member_id);
	$stat = $db->update($table_member, $data_to_update);
	$db->where('id',$member_id);
	$details = $db->getOne($table_member);
	
    if($stat)
    {
        $_SESSION['success'] = str_replace("{s}",$details['member_email'],$lang['members-log-update-success']);
        header('location: members.php');
        exit();
    }
}



if($edit)
{
    $db->where('id', $member_id);
    $member= $db->getOne($table_member);

}

require_once 'includes/header.php';
?>

<main>
	<div class="container-fluid">
		<h1 class="mt-4"><?php echo $lang['members-edit']; ?></h1>
		<ol class="breadcrumb mb-4">
			<li class="breadcrumb-item"><a href="index.php"><?php echo $lang['nav-dashboard']; ?></a></li>
			<li class="breadcrumb-item"><a href="members.php"><?php echo $lang['nav-members']; ?></a></li>
			<li class="breadcrumb-item active"><?php echo $lang['members-edit']; ?></li>
		</ol>
		
		<div class="card mb-4">
			<div class="card-header">
				<span class="fa fa-user-edit fa-fw"></span> <?php echo $lang['members-details']; ?>
			</div>
			<div class="card-body">
				 <?php
				include('./includes/flash_messages.php')
				?>
				<form class="" action="" method="post" enctype="multipart/form-data" id="member_form">
					<?php  include_once('./includes/forms/member_form.php'); ?>
				</form>
			</div>
		</div>
	</div>
</main>

<?php include_once 'includes/footer.php'; ?>