<?php
session_start();
require_once './config/config.php';
require_once './language/language.php';
require_once 'includes/auth_validate.php';

if($_SESSION['admin_type']!='super'){
	$_SESSION['failure'] = $lang['permission-denied-log'];
	header('location: products.php');
	exit;
}

// Sanitize if you want
$product_id = filter_input(INPUT_GET, 'product_id', FILTER_VALIDATE_INT);
$operation = filter_input(INPUT_GET, 'operation',FILTER_SANITIZE_SPECIAL_CHARS ); 
($operation == 'edit') ? $edit = true : $edit = false;
//Handle update request 
if ($_SERVER['REQUEST_METHOD'] == 'POST') 
{
    $product_id = filter_input(INPUT_GET, 'product_id', FILTER_VALIDATE_INT);
    $data_to_update = filter_input_array(INPUT_POST);
	
    $db->where('id',$product_id);
    $stat = $db->update($table_product, $data_to_update);
	$db->where('id',$product_id);
	$details = $db->getOne($table_product);

    if($stat)
    {
        $_SESSION['success'] = str_replace("{s}",$details['order_name'],$lang['products-log-update-success']);
        header('location: products.php');
        exit();
    }
}



if($edit)
{
    $db->where('id', $product_id);
    $product= $db->getOne($table_product);

}

require_once 'includes/header.php';
?>

<main>
	<div class="container-fluid">
		<h1 class="mt-4"><?php echo $lang['products-edit']; ?></h1>
		<ol class="breadcrumb mb-4">
			<li class="breadcrumb-item"><a href="index.php"><?php echo $lang['nav-dashboard']; ?></a></li>
			<li class="breadcrumb-item"><a href="members.php"><?php echo $lang['nav-products']; ?></a></li>
			<li class="breadcrumb-item active"><?php echo $lang['products-edit']; ?></li>
		</ol>
		
		<div class="card mb-4">
			<div class="card-header">
				<span class="fa fa-shopping-cart fa-fw"></span> <?php echo $lang['products-details']; ?>
			</div>
			<div class="card-body">
				 <?php
				include('./includes/flash_messages.php')
				?>
				<form class="" action="" method="post" enctype="multipart/form-data" id="product_form">
					<?php  include_once('./includes/forms/product_form.php'); ?>
				</form>
			</div>
		</div>
	</div>
</main>

<!--Main container end-->
<?php include_once 'includes/footer.php'; ?>