<?php
session_start();
require_once './config/config.php';
require_once './language/language.php';
require_once './includes/auth_validate.php';

//$_SESSION['admin_type'] != 'super' ||
if ($_SESSION['admin_type'] != 'vendor') {
	$_SESSION['failure'] = $lang['permission-denied-log'];
	header('location: redeem.php');
	exit;
}

//serve POST method, After successful insert, redirect to customers.php page.
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	//Mass Insert Data. Keep "name" attribute in html form same as column name in mysql table.
	$data_to_store = filter_input_array(INPUT_POST);

	$getDate = date($data_to_store['expire_date']);
	$data_to_store['expire_date'] = date('Y-m-d H:i:s', strtotime($getDate . "00:00:00"));
	if (isset($data_to_store['game_type']) && $data_to_store['game_type'] == 'scratchandwin') {

		/** get id of the current vendor */
		$db->where('vendor_name', $_SESSION['user_name']);
		$vendor = $db->getOne($table_vendors);
		/** vendor id and balance */
		$vendor['vendor_balance'] = $vendor['vendor_balance'] - $data_to_store['redeem_total'];
		$db->where('id', $vendor['id']);
		$stat = $db->update($table_vendors, $vendor);
		//var_dump($vendor);
	}
	$last_id = $db->insert($table_redeem_code, $data_to_store);
	//If the insert was successful, give success message and redirect to redeem.php page
	if ($last_id) {
		$_SESSION['success'] = $lang['redeem-log-add-success'];
		header('location: redeem.php');
		exit();
	}
}

//We are using same form for adding and editing. This is a create form so declare $edit = false.
$edit = false;

require_once 'includes/header.php';
?>

<main>
	<div class="container-fluid">
		<h1 class="mt-4"><?php echo $lang['redeem-add']; ?></h1>
		<ol class="breadcrumb mb-4">
			<li class="breadcrumb-item"><a href="index.php"><?php echo $lang['nav-dashboard']; ?></a></li>
			<li class="breadcrumb-item"><a href="redeem.php"><?php echo $lang['nav-redeem']; ?></a></li>
			<li class="breadcrumb-item active"><?php echo $lang['redeem-add']; ?></li>
		</ol>

		<div class="card mb-4">
			<div class="card-header">
				<span class="fa fa-gift fa-fw"></span> <?php echo $lang['redeem-details']; ?>
			</div>
			<div class="card-body">
				<?php
				include('./includes/flash_messages.php')
				?>
				<form class="" action="" method="post" enctype="multipart/form-data" id="redeem_form">
					<?php include_once('./includes/forms/redeem_form.php'); ?>
				</form>
			</div>
		</div>
	</div>

	<?php
	include('includes/modal/crop.php')
	?>
</main>

<?php include_once 'includes/footer.php'; ?>