<?php
session_start();
require_once './config/config.php';
require_once './language/language.php';
require_once 'includes/auth_validate.php';

if ($_SESSION['admin_type'] != 'super') {
	$_SESSION['failure'] = $lang['permission-denied-log'];
	header('location: redeem.php');
	exit;
}

// Sanitize if you want
$redeem_id = filter_input(INPUT_GET, 'redeem_id', FILTER_VALIDATE_INT);
$operation = filter_input(INPUT_GET, 'operation', FILTER_SANITIZE_SPECIAL_CHARS);
$page = filter_input(INPUT_GET, 'page', FILTER_SANITIZE_SPECIAL_CHARS);
($operation == 'edit') ? $edit = true : $edit = false;
//Handle update request 
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	$redeem_id = filter_input(INPUT_GET, 'redeem_id', FILTER_VALIDATE_INT);
	$data_to_update = filter_input_array(INPUT_POST);

	$getDate = date($data_to_update['expire_date']);
	$data_to_update['expire_date'] = date('Y-m-d H:i:s', strtotime($getDate . "00:00:00"));

	$db->where('id', $redeem_id);
	$stat = $db->update($table_redeem_code, $data_to_update);
	$db->where('id', $redeem_id);
	$details = $db->getOne($table_redeem_code);

	if ($stat) {
		$_SESSION['success'] = str_replace("{s}", $details['redeem_code'], $lang['redeem-log-update-success']);
		header('location: redeem.php');
		exit();
	}
}



if ($edit) {
	$db->where('id', $redeem_id);
	$redeem = $db->getOne($table_redeem_code);
}

require_once 'includes/header.php';
?>

<main>
	<div class="container-fluid">
		<h1 class="mt-4"><?php echo $lang['redeem-edit']; ?></h1>
		<ol class="breadcrumb mb-4">
			<li class="breadcrumb-item"><a href="index.php"><?php echo $lang['nav-dashboard']; ?></a></li>
			<li class="breadcrumb-item"><a href="redeem.php"><?php echo $lang['nav-redeem']; ?></a></li>
			<li class="breadcrumb-item active"><?php echo $lang['redeem-edit']; ?></li>
		</ol>

		<div class="card mb-4">
			<div class="card-header">
				<span class="fa fa-gift fa-fw"></span> <?php echo $lang['redeem-details']; ?>
			</div>
			<div class="card-body">
				<?php
				include('./includes/flash_messages.php')
				?>
				<form class="" action="" method="post" enctype="multipart/form-data" id="redeem_form">
					<?php include_once('./includes/forms/redeem_form.php'); ?>
				</form>
			</div>
		</div>
	</div>

	<?php
	include('includes/modal/crop.php')
	?>
</main>

<!--Main container end-->
<?php include_once 'includes/footer.php'; ?>