<?php 
session_start();
require_once 'includes/auth_validate.php';
require_once './config/config.php';
require_once './language/language.php';
$batch_id = filter_input(INPUT_POST, 'batch_id');
$update_status = filter_input(INPUT_POST, 'update_status');

if ($batch_id && $_SERVER['REQUEST_METHOD'] == 'POST') 
{

	if($_SESSION['admin_type']!='super'){
		$_SESSION['failure'] = $lang['permission-denied-log'];
    	header('location: redemption.php');
        exit;
	}
	
	$batch_id = explode (",", $batch_id);
	$totalRecord = 0;
	$completeRecord = 0;
	$rewardRecord = 0;
	$autoreward_message = '';
	$status_message = '';
	
	if($update_status == 'remove'){
		if($_SESSION['admin_type']!='super'){
			$_SESSION['failure'] = $lang['permission-denied-log'];
			header('location: redemption.php');
			exit;
		}

		$status_message = $lang['redemption-log-batch-remove-success'];
		foreach ($batch_id as &$redeem_id) {
			$db->where('id', $redeem_id);
			$status = $db->delete($table_redemption);
			if($status){
				$completeRecord++;	
			}
			
			$totalRecord++;
		}
	}else{
		$status_message = $lang['redemption-log-batch-checked-success'];
		foreach ($batch_id as &$reward_id) {
			if($autorewards){
				//get reward id
				$db->where('id', $reward_id);
				$redeem = $db->getOne ($table_redemption);
				
				if($redeem['redeem_status'] == 0){
					//get member
					$db->where('member_id', $redeem['member_id']);
					$db->where('game_type', $redeem['game_type']);
					$member = $db->getOne ($table_point);
					
					//get rewards
					$db->where('id', $redeem['reward_id']);
					$rewards = $db->getOne ($table_rewards);
					
					$data = Array (
						'member_chance' => $member['member_chance']+$rewards['reward_for_chances'],
						'date_updated' => $db->now()
					);
					$db->where('member_id', $redeem['member_id']);
					if(!$global_game_points){
						$db->where('game_type', $redeem['game_type']);
					}
					$status = $db->update($table_point, $data);
					
					if ($status) 
					{
						$rewardRecord++;
					}
				}
			}
			
			$db->where('id', $reward_id);
		
			$data = Array (
				'redeem_status' => $update_status
			);
			$status = $db->update($table_redemption, $data);
			if($status){
				$completeRecord++;	
			}
			
			$totalRecord++;
		}
		
		if($autorewards){
			$autoreward_message = "<br/>".$completeRecord.$lang['redemption-log-batch-of'].$totalRecord.$lang['redemption-log-batch-update-success'];	
		}
	}
	
	$_SESSION['info'] = $completeRecord.$lang['redemption-log-batch-of'].$totalRecord.$status_message.$autoreward_message;
	header('location: redemption.php');
	exit;
}