<?php
session_start();
require_once './config/config.php';
require_once './language/language.php';
require_once 'includes/auth_validate.php';

if ($_SESSION['admin_type'] != 'super') {
	$_SESSION['failure'] = $lang['permission-denied-log'];
	header('location: vendors.php');
	exit;
}

// Sanitize if you want
$vendor_id = filter_input(INPUT_GET, 'vendor_id', FILTER_VALIDATE_INT);
$operation = filter_input(INPUT_GET, 'operation', FILTER_SANITIZE_SPECIAL_CHARS);
($operation == 'edit') ? $edit = true : $edit = false;

//Handle update request 
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	$member_id = filter_input(INPUT_GET, 'vendor_id', FILTER_VALIDATE_INT);

	$data_to_update = filter_input_array(INPUT_POST);

	if (empty($data_to_update['vendor_password'])) {
		unset($data_to_update['vendor_password']);
	} else {
		$data_to_update['vendor_password'] = md5($data_to_update['vendor_password']);
	}

	$db->where('id', $vendor_id);
	$stat = $db->update($table_vendors, $data_to_update);
	$db->where('id', $vendor_id);
	$details = $db->getOne($table_vendors);

	if ($stat) {
		$_SESSION['success'] = str_replace("{s}", $details['vendor_email'], $lang['vendors-log-update-success']);
		header('location: vendors.php');
		exit();
	}
}


if ($edit) {
	$db->where('id', $vendor_id);
	$vendor = $db->getOne($table_vendors);
}

require_once 'includes/header.php';
?>

<main>
	<div class="container-fluid">
		<h1 class="mt-4"><?php echo $lang['vendors-edit']; ?></h1>
		<ol class="breadcrumb mb-4">
			<li class="breadcrumb-item"><a href="index.php"><?php echo $lang['nav-dashboard']; ?></a></li>
			<li class="breadcrumb-item"><a href="vendors.php"><?php echo $lang['nav-vendors']; ?></a></li>
			<li class="breadcrumb-item active"><?php echo $lang['vendors-edit']; ?></li>
		</ol>

		<div class="card mb-4">
			<div class="card-header">
				<span class="fa fa-user-edit fa-fw"></span> <?php echo $lang['vendors-details']; ?>
			</div>
			<div class="card-body">
				<?php
				include('./includes/flash_messages.php')
				?>
				<form class="" action="" method="post" enctype="multipart/form-data" id="vendor_form">
					<?php include_once('./includes/forms/vendor_form.php'); ?>
				</form>
			</div>
		</div>
	</div>
</main>

<?php include_once 'includes/footer.php'; ?>