<?php
session_start();
require_once 'includes/auth_validate.php';
require_once './config/config.php';
require_once './language/language.php';
$batch_id = filter_input(INPUT_POST, 'batch_id');
$update_status = filter_input(INPUT_POST, 'update_status');

if ($batch_id && $_SERVER['REQUEST_METHOD'] == 'POST') {

	if ($_SESSION['admin_type'] != 'super') {
		$_SESSION['failure'] = $lang['permission-denied-log'];
		header('location: vendors.php');
		exit;
	}

	$batch_id = explode(",", $batch_id);
	$totalRecord = 0;
	$completeRecord = 0;
	$status_message = '';

	if ($update_status == 'remove') {
		$status_message = $lang['vendors-log-batch-remove-success'];
		foreach ($batch_id as &$member_id) {
			$db->where('id', $member_id);
			$status = $db->delete($table_vendors);
			if ($status) {
				$completeRecord++;
			}

			$totalRecord++;
		}
	} else if ($update_status == 'active') {
		$status_message = $lang['vendors-log-batch-active-success'];
		foreach ($batch_id as &$filter_id) {
			$data_to_store['active_status'] = 1;
			$db->where('id', $filter_id);
			$status = $db->update($table_vendors, $data_to_store);

			if ($status) {
				$completeRecord++;
			}
			$totalRecord++;
		}
	} else if ($update_status == 'inactive') {
		$status_message = $lang['vendors-log-batch-inactive-success'];
		foreach ($batch_id as &$filter_id) {
			$data_to_store['active_status'] = 0;
			$db->where('id', $filter_id);
			$status = $db->update($table_vendors, $data_to_store);

			if ($status) {
				$completeRecord++;
			}
			$totalRecord++;
		}
	}

	$_SESSION['info'] = $completeRecord . $lang['vendors-log-batch-of'] . $totalRecord . $status_message;
	header('location: vendors.php');
	exit;
}
