<?php
session_start();
require_once './config/config.php';
require_once './language/language.php';
require_once 'includes/auth_validate.php';

if($_SESSION['admin_type']!='super'){
	$_SESSION['failure'] = $lang['permission-denied-log'];
	header('location: assets.php');
	exit;
}

// Sanitize if you want
$asset_id = filter_input(INPUT_GET, 'asset_id', FILTER_VALIDATE_INT);
$operation = filter_input(INPUT_GET, 'operation',FILTER_SANITIZE_STRING);
$page = filter_input(INPUT_GET, 'page',FILTER_SANITIZE_STRING);
($operation == 'edit') ? $edit = true : $edit = false;
//Handle update request 
if ($_SERVER['REQUEST_METHOD'] == 'POST') 
{
    $asset_id = filter_input(INPUT_GET, 'asset_id', FILTER_VALIDATE_INT);
    $data_to_update = filter_input_array(INPUT_POST);
	
    $db->where('id',$asset_id);
    $stat = $db->update($game_assets, $data_to_update);
	$db->where('id',$asset_id);
	$details = $db->getOne($game_assets);

    if($stat)
    {
        $_SESSION['success'] = str_replace("{s}",$details['image'],$lang['image-assets-log-update-success']);
        header('location: assets.php');
        exit();
    }
}



if($edit)
{
    $db->where('id', $asset_id);
    $assets= $db->getOne($game_assets);

}

require_once 'includes/header.php';
?>

<main>
	<div class="container-fluid">
		<h1 class="mt-4"><?php echo $lang['image-assets-edit']; ?></h1>
		<ol class="breadcrumb mb-4">
			<li class="breadcrumb-item"><a href="index.php"><?php echo $lang['nav-dashboard']; ?></a></li>
			<li class="breadcrumb-item"><a href="assets.php"><?php echo $lang['nav-image-assets']; ?></a></li>
			<li class="breadcrumb-item active"><?php echo $lang['image-assets-edit']; ?></li>
		</ol>
		
		<div class="card mb-4">
			<div class="card-header">
				<span class="fa fa-gift fa-fw"></span> <?php echo $lang['image-assets-details']; ?>
			</div>
			<div class="card-body">
				 <?php
				include('./includes/flash_messages.php')
				?>
				<form class="" action="" method="post" enctype="multipart/form-data" id="asset_form">
					<?php  include_once('./includes/forms/assets_form.php'); ?>
				</form>
			</div>
		</div>
	</div>
	
	<?php
		include('includes/modal/assets.php')
	?>
</main>

<!--Main container end-->
<?php include_once 'includes/footer.php'; ?>