<?php 
session_start();
require_once 'includes/auth_validate.php';
require_once './config/config.php';
require_once './language/language.php';
$batch_id = filter_input(INPUT_POST, 'batch_id');
$update_status = filter_input(INPUT_POST, 'update_status');

if ($batch_id && $_SERVER['REQUEST_METHOD'] == 'POST') 
{

	if($_SESSION['admin_type']!='super'){
		$_SESSION['failure'] = $lang['permission-denied-log'];
    	header('location: gamesettings.php');
        exit;
	}
	
	$batch_id = explode (",", $batch_id);
	$totalRecord = 0;
	$completeRecord = 0;
	$status_message = '';
	
	if($update_status == 'remove'){
		$status_message = $lang['game-settings-log-batch-remove-success'];
		foreach ($batch_id as &$gamesetting_id) {
			$db->where('id', $gamesetting_id);
			$status = $db->delete($game_settings);
			if($status){
				$completeRecord++;	
			}
			
			$totalRecord++;
		}
	}else if($update_status == 'active'){
		$status_message = $lang['game-settings-log-batch-active-success'];
		foreach ($batch_id as &$gamesetting_id) {
			$data_to_store['setting_status'] = 1;
			$db->where('id', $gamesetting_id);
			$status = $db->update ($game_settings, $data_to_store);

			if($status){
				$completeRecord++;	
			}
			$totalRecord++;
		}
	}else if($update_status == 'inactive'){
		$status_message = $lang['game-settings-log-batch-inactive-success'];
		foreach ($batch_id as &$gamesetting_id) {
			$data_to_store['setting_status'] = 0;
			$db->where('id', $gamesetting_id);
			$status = $db->update ($game_settings, $data_to_store);

			if($status){
				$completeRecord++;	
			}
			$totalRecord++;
		}
	}
	
	$_SESSION['info'] = $completeRecord.$lang['game-settings-log-batch-of'].$totalRecord.$status_message;
	header('location: gamesettings.php');
	exit;
}