<?php
session_start();
require_once './config/config.php';
require_once './language/language.php';
require_once './includes/auth_validate.php';

if($_SESSION['admin_type']!='super'){
	$_SESSION['failure'] = $lang['permission-denied-log'];
	header('location: points.php');
	exit;
}

//serve POST method, After successful insert, redirect to customers.php page.
if ($_SERVER['REQUEST_METHOD'] == 'POST') 
{
    //Mass Insert Data. Keep "name" attribute in html form same as column name in mysql table.
    $data_to_store = filter_input_array(INPUT_POST);
    $last_id = $db->insert ($table_point, $data_to_store);
    
    if($last_id)
    {
    	$_SESSION['success'] = $lang['points-log-add-success'];
    	header('location: points.php');
    	exit();
    }  
}

//We are using same form for adding and editing. This is a create form so declare $edit = false.
$edit = false;

require_once 'includes/header.php'; 
?>
<div id="page-wrapper">
<div class="row">
     <div class="col-lg-12">
            <h2 class="page-header"><?php echo $lang['points-add']; ?></h2>
        </div>
        
</div>
    <form class="form" action="" method="post"  id="point_form" enctype="multipart/form-data">
       <?php  include_once('./includes/forms/point_form.php'); ?>
    </form>
</div>


<script type="text/javascript">
$(document).ready(function(){
   $("#point_form").validate({
       rules: {
            game_type: {
                required: true,
                minlength: 3
            },
            member_id: {
                required: true,
                minlength: 3
            },
			member_email: {
                required: true,
                minlength: 3,
				email: true
            },   
        }
    });
});
</script>

<?php include_once 'includes/footer.php'; ?>