<?php 
session_start();
require_once 'includes/auth_validate.php';
require_once './config/config.php';
require_once './language/language.php';
$update_approve = filter_input(INPUT_POST, 'update_approve');
$update_reject = filter_input(INPUT_POST, 'update_reject');
$approve_id = filter_input(INPUT_POST, 'approve_id');
$reject_id = filter_input(INPUT_POST, 'reject_id');
$current_update;
$current_id;

if($update_approve){
	$current_update = $update_approve;
	$current_id = $approve_id;
}else if($update_reject){
	$current_update = $update_reject;	
	$current_id = $reject_id;
}

if ($current_id && $current_update && $_SERVER['REQUEST_METHOD'] == 'POST') 
{

	if($_SESSION['admin_type']!='super'){
		$_SESSION['failure'] = $lang['permission-denied-log'];
    	header('location: redemption.php');
        exit;
	}
	
	$autoreward_message = '';
	if($autorewards && $update_approve){
		//get reward id
		$db->where('id', $current_id);
		$redeem = $db->getOne ($table_redemption);
		
		//get member
		$db->where('member_id', $redeem['member_id']);
		$db->where('game_type', $redeem['game_type']);
		$member = $db->getOne ($table_point);
		
		//get rewards
		$db->where('id', $redeem['reward_id']);
		$rewards = $db->getOne ($table_rewards);
		
		$data = Array (
			'member_chance' => $member['member_chance']+$rewards['reward_for_chances'],
			'date_updated' => $db->now()
		);
		$db->where('member_id', $redeem['member_id']);
		if(!$global_game_points){
			$db->where('game_type', $redeem['game_type']);
		}
		$status = $db->update($table_point, $data);
		
		if ($status) 
		{
			$autoreward_message = '<br/>'.$lang['redemption-log-approve-reward'];
		}
	}
	
    $reward_id = $current_id;
    $db->where('id', $reward_id);
	
	$data = Array (
		'redeem_status' => $current_update
	);
    $status = $db->update($table_redemption, $data);
	$db->where('id',$reward_id);
	$details = $db->getOne($table_redemption);
    
    if ($status) 
    {
        $_SESSION['info'] = str_replace("{s}",$details['id'],$lang['points-log-approve-success']).$autoreward_message;
        header('location: redemption.php');
        exit;
    }
    else
    {
    	$_SESSION['failure'] = $lang['redemption-log-approve-fail'];
    	header('location: redemption.php');
        exit;

    }
    
}