<?php
session_start();
require_once './config/config.php';
require_once './language/language.php';
require_once 'includes/auth_validate.php';

if($_SESSION['admin_type']!='super'){
	$_SESSION['failure'] = $lang['permission-denied-log'];
	header('location: transactions.php');
	exit;
}

// Sanitize if you want
$transaction_id = filter_input(INPUT_GET, 'transaction_id', FILTER_VALIDATE_INT);
$operation = filter_input(INPUT_GET, 'operation',FILTER_SANITIZE_STRING); 
($operation == 'edit') ? $edit = true : $edit = false;
//Handle update request 
if ($_SERVER['REQUEST_METHOD'] == 'POST') 
{
    $transaction_id = filter_input(INPUT_GET, 'transaction_id', FILTER_VALIDATE_INT);

    $data_to_update = filter_input_array(INPUT_POST);
    
    $db->where('id',$transaction_id);
    $stat = $db->update($table_transaction, $data_to_update);
	$db->where('id', $transaction_id);
	$details = $db->getOne($table_transaction);

    if($stat)
    {
        $_SESSION['success'] = str_replace("{s}",$details['id'],$lang['transactions-log-update-success']);
        header('location: transactions.php');
        exit();
    }
}



if($edit)
{
    $db->where('id', $transaction_id);
    $transaction= $db->getOne($table_transaction);

}

require_once 'includes/header.php';
?>

<main>
	<div class="container-fluid">
		<h1 class="mt-4"><?php echo $lang['transactions-edit']; ?></h1>
		<ol class="breadcrumb mb-4">
			<li class="breadcrumb-item"><a href="index.php"><?php echo $lang['nav-dashboard']; ?></a></li>
			<li class="breadcrumb-item"><a href="transactions.php"><?php echo $lang['nav-transactions']; ?></a></li>
			<li class="breadcrumb-item active"><?php echo $lang['transactions-edit']; ?></li>
		</ol>
		
		<div class="card mb-4">
			<div class="card-header">
				<span class="fa fa-credit-card fa-fw"></span> <?php echo $lang['transactions-details']; ?>
			</div>
			<div class="card-body">
				 <?php
				include('./includes/flash_messages.php')
				?>
				<form class="" action="" method="post" enctype="multipart/form-data" id="transaction_form">
					<?php  include_once('./includes/forms/transaction_form.php'); ?>
				</form>
			</div>
		</div>
	</div>
</main>

<?php include_once 'includes/footer.php'; ?>