<?php
session_start();
require_once './config/config.php';
require_once './language/language.php';
require_once 'includes/auth_validate.php';

if($_SESSION['admin_type']!='super'){
	$_SESSION['failure'] = $lang['permission-denied-log'];
	header('location: gamesettings.php');
	exit;
}

// Sanitize if you want
$gamesetting_id = filter_input(INPUT_GET, 'gamesetting_id', FILTER_VALIDATE_INT);
$operation = filter_input(INPUT_GET, 'operation',FILTER_SANITIZE_STRING);
$page = filter_input(INPUT_GET, 'page',FILTER_SANITIZE_STRING);
($operation == 'edit') ? $edit = true : $edit = false;
//Handle update request 
if ($_SERVER['REQUEST_METHOD'] == 'POST') 
{
    $gamesetting_id = filter_input(INPUT_GET, 'gamesetting_id', FILTER_VALIDATE_INT);
    $data_to_update = filter_input_array(INPUT_POST);
	
    $db->where('id',$gamesetting_id);
    $stat = $db->update($game_settings, $data_to_update);
	$db->where('id',$gamesetting_id);
	$details = $db->getOne($game_settings);

    if($stat)
    {
        $_SESSION['success'] = str_replace("{s}",$details['setting_name'],$lang['game-settings-log-update-success']);
        header('location: gamesettings.php');
        exit();
    }
}



if($edit)
{
    $db->where('id', $gamesetting_id);
    $gamesettings= $db->getOne($game_settings);

}

require_once 'includes/header.php';
?>

<main>
	<div class="container-fluid">
		<h1 class="mt-4"><?php echo $lang['game-settings-edit']; ?></h1>
		<ol class="breadcrumb mb-4">
			<li class="breadcrumb-item"><a href="index.php"><?php echo $lang['nav-dashboard']; ?></a></li>
			<li class="breadcrumb-item"><a href="gamesettings.php"><?php echo $lang['nav-game-settings']; ?></a></li>
			<li class="breadcrumb-item active"><?php echo $lang['game-settings-edit']; ?></li>
		</ol>
		
		<div class="card mb-4">
			<div class="card-header">
				<span class="fa fa-gift fa-fw"></span> <?php echo $lang['game-settings-details']; ?>
			</div>
			<div class="card-body">
				 <?php
				include('./includes/flash_messages.php')
				?>
				<form class="" action="" method="post" enctype="multipart/form-data" id="gamesettings_form">
					<?php  include_once('./includes/forms/gamesettings_form.php'); ?>
				</form>
			</div>
		</div>
	</div>
</main>

<!--Main container end-->
<?php include_once 'includes/footer.php'; ?>