<!--Main container end-->
<script type="text/javascript">
	$uploadCrop = '';
	$imageReady = false;
	
    $(document).ready(function () {
	    $("#crop-image").on("hide.bs.modal", function () {
			if(!$imageReady){
				$("#image_upload").val("");
			}
		});
		
		$('#cropLoading').hide();
		$("#btnCropImage").click(function(){
			croppedUploadImage();
		});
		
		$('#image_upload').off().on('change', function () { readUploadImageFile(this); });
    });
	
	function croppedUploadImage(){
		$("#btnCropImage").hide();
		$('#cropLoading').show();
		
		var cropSize = {width:300, height:300};
		if($('.image_path').attr('data-type') == 'asset'){
			cropSize = {width:parseInt($('#sizeW').val(),10), height:parseInt($('#sizeH').val(),10)};
		}
		
		$uploadCrop.croppie('result', {
			type: 'canvas',
			size: cropSize
		}).then(function (resp) {
			$imageReady = true;
			
			$.ajax({
				type: "POST",
				url: "save_image.php",
				data: {img:resp, type:$('.image_path').attr('data-type')}
			}).done(function(o) {
				if (o.indexOf('Warning') > -1) {
				  alert('Failed to open stream: Permission denied!');
				}
				
				$("#btnCropImage").show();
				$('#cropLoading').hide();
				
				console.log(o);
				$('#image_load').attr('src', $('.image_path').attr('data-directory')+jQuery.parseJSON(o));
				$('.image_path').val(jQuery.parseJSON(o));
				$('#crop-image').modal('hide');
			})
		});
	}
	
	function readUploadImageFile(input) {
		if (input.files && input.files[0]) {
			var cropSize = {
				viewport: {
					width: 250,
					height: 250
				},
				enableExif: true,
				boundary: {
					width: 300,
					height: 300
				},
				showZoomer: true,
				enableOrientation: true
			};
			
			var reader = new FileReader();
			reader.onload = function (e) {
				var image = new Image();
    			image.src = e.target.result;
    			image.onload = function() {
					var modalW = this.width > 500 ? this.width + 50 : 500;
					$('#crop-image .modal-dialog').css('max-width', modalW);

					var maxW = this.width;
					var maxH = this.height;

					$('#sizeW').val(maxW);
					$('#sizeH').val(maxH);
					
					if($('.image_path').attr('data-type') == 'asset'){
						cropSize = {
							viewport: {
								width: maxW,
								height: maxH
							},
							enableExif: true,
							boundary: {
								width: maxW,
								height: maxH
							},
							enableResize:false,
							showZoomer: false,
							enableOrientation: true
						};
					}
					
					setTimeout(function(){
						if($uploadCrop != ''){
							$uploadCrop.croppie('destroy');
						}

						$imageReady = false;
						$uploadCrop = $('#cropImageHolder').croppie(cropSize);

						$uploadCrop.croppie('bind', {
							url: e.target.result
						}).then(function(){
							console.log('jQuery bind complete');
						});

					}, 500);
				};
				image.src = reader.result;
				
				$('#crop-image').modal('show');
			}
			reader.readAsDataURL(input.files[0]);
		}
		else {
			alert("Sorry - you're browser doesn't support the FileReader API");
		}
	}
</script>