/*!
    * Start Bootstrap - SB Admin v6.0.0 (https://startbootstrap.com/templates/sb-admin)
    * Copyright 2013-2020 Start Bootstrap
    * Licensed under MIT (https://github.com/BlackrockDigital/startbootstrap-sb-admin/blob/master/LICENSE)
    */
    (function($) {
    "use strict";

    // Add active state to sidbar nav links
    var path = window.location.href; // because the 'href' property of the DOM element is the absolute path
	var membership_array = ['members','points','redemption','code','transactions','gamelogs'];
	var interface_array = ['assets','gamesettings'];
		
	$("#layoutSidenav_nav .sb-sidenav a.nav-link").each(function() {
		var current_path = window.location.pathname.split('/').pop();
		current_path = current_path.split('.').shift();
		
		var link_path = this.href.split('/').pop();
		link_path = link_path.split('.').shift();
		
		if (link_path === current_path.substring(0, link_path.length) && $(this).attr('href') != '#') {
			if(membership_array.indexOf(link_path) != -1){
				$('#collapseMemberLayouts').collapse();
			}
			
			if(interface_array.indexOf(link_path) != -1){
				$('#collapseInterfaceLayouts').collapse();
			}
			
			$(this).addClass("active");
		}
	});

    // Toggle the side navigation
    $("#sidebarToggle").on("click", function(e) {
        e.preventDefault();
        $("body").toggleClass("sb-sidenav-toggled");
    });
})(jQuery);



function getFileName(path) {
	return path.match(/[-_\w]+[.][\w]+$/i)[0];
}

function copyPathFunc(path){
	var aux = document.createElement("input");
	aux.setAttribute("value", path);
	document.body.appendChild(aux);
	aux.select();
	document.execCommand("copy");
	document.body.removeChild(aux);
	
	$('.imagePath').html('<strong>'+path+'</strong>');
	$('#copy-path').modal('show');
}

function convertJSON(val){
	var newArray = [];
	newArray = val;
	newArray = newArray.replace(/\s/g,'');
	newArray = newArray.replace(/'/g,'"');
	newArray = newArray.replace(/([{,])(\s*)([A-Za-z0-9_\-]+?)\s*:/g, '$1"$3":');
	newArray = newArray.replace(/;/g,'');
	newArray = newArray.replace(/([{,])(\s*)([A-Za-z0-9_\-]+?)\s*:/g, '$1"$3":');
	newArray = newArray.replace(/},}/g,'}}');
	newArray = newArray.replace(/},]/g,'}]');

	var finalOutput = '';

	try {
		var tmpData = JSON.parse(newArray);
		finalOutput = JSON.stringify(tmpData, null, '\t');
	}
	catch(err) {
		alert('Invalid data, can\'t convert to JSON format!')
		finalOutput = val;
	}

	return finalOutput;
}

function populateModal(type, id, file, message, item){
	var modalHTML = '<div class="modal fade" id="confirm-'+type+'-'+id+'" role="dialog">';
	modalHTML += '<div class="modal-dialog modal-dialog-centered">';
	modalHTML += '<form action="'+file+'" method="POST">';
	modalHTML += '<div class="modal-content">';
	modalHTML += '<div class="modal-header">';
	modalHTML += '<h4 class="modal-title">Confirm</h4>';
	modalHTML += '<button type="button" class="close" data-dismiss="modal">&times;</button>';
	modalHTML += '</div>';
	modalHTML += '<div class="modal-body">';
	if(type == 'approve'){
		modalHTML += '<input type="hidden" name="approve_id" id="approve_id" value="'+id+'">';
		modalHTML += '<input type="hidden" name="update_approve" id="update_approve" value="2">';
	}else if(type == 'reject'){
		modalHTML += '<input type="hidden" name="reject_id" id="reject_id" value="'+id+'">';
		modalHTML += '<input type="hidden" name="update_reject" id="update_reject" value="1">';
	}else{
		modalHTML += '<input type="hidden" name="del_id" id="del_id" value="'+id+'">';
	}
	modalHTML += '<p>'+message+'</p>';
	modalHTML += '<p class="text-center"><strong>'+item+'</strong></p>';
	modalHTML += '</div>';
	modalHTML += '<div class="modal-footer">';
	modalHTML += '<button type="submit" class="btn btn-primary pull-left">Confirm</button>';
	modalHTML += '<button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>';
	modalHTML += '</div>';
	modalHTML += '</div>';
	modalHTML += '</form>';
	modalHTML += '</div>';
	modalHTML += '</div>';

	return modalHTML;
}
