<?php
session_start();
require_once './config/config.php';
require_once './language/language.php';
require_once 'includes/auth_validate.php';

if($_SESSION['admin_type']!='super'){
	$_SESSION['failure'] = $lang['permission-denied-log'];
	header('location: points.php');
	exit;
}

// Sanitize if you want
$point_id = filter_input(INPUT_GET, 'point_id', FILTER_VALIDATE_INT);
$operation = filter_input(INPUT_GET, 'operation',FILTER_SANITIZE_STRING); 
($operation == 'edit') ? $edit = true : $edit = false;
//Handle update request 
if ($_SERVER['REQUEST_METHOD'] == 'POST') 
{
    $point_id = filter_input(INPUT_GET, 'point_id', FILTER_VALIDATE_INT);

    $data_to_update = filter_input_array(INPUT_POST);
    
    $db->where('id',$point_id);
    $stat = $db->update($table_point, $data_to_update);
	$db->where('id',$point_id);
	$details = $db->getOne($table_point);

    if($stat)
    {
        $_SESSION['success'] = str_replace("{s}",$details['id'],$lang['points-log-update-success']);
        header('location: points.php');
        exit();
    }
}

if($edit)
{
    $db->where('id', $point_id);
    $point= $db->getOne($table_point);

}

require_once 'includes/header.php';
?>

<main>
	<div class="container-fluid">
		<h1 class="mt-4"><?php echo $lang['points-edit']; ?></h1>
		<ol class="breadcrumb mb-4">
			<li class="breadcrumb-item"><a href="index.php"><?php echo $lang['nav-dashboard']; ?></a></li>
			<li class="breadcrumb-item"><a href="points.php"><?php echo $lang['nav-points']; ?></a></li>
			<li class="breadcrumb-item active"><?php echo $lang['points-edit']; ?></li>
		</ol>
		
		<div class="card mb-4">
			<div class="card-header">
				<span class="fa fa-gamepad fa-fw"></span> <?php echo $lang['points-details']; ?>
			</div>
			<div class="card-body">
				 <?php
				include('./includes/flash_messages.php')
				?>
				<form class="" action="" method="post" enctype="multipart/form-data" id="point_form">
					<?php  include_once('./includes/forms/point_form.php'); ?>
				</form>
			</div>
		</div>
	</div>
</main>

<?php include_once 'includes/footer.php'; ?>