<?php
	
	require_once './config/config.php';
	
	$params = $columns = $totalRecords = $data = array();
	$params = $_REQUEST;

	$where_condition = $sqlTot = $sqlRec = "";

	$columns = array('id', 'game_type', 'redeem_code', 'redeem_name', 'redeem_total', 'redeem_type', 'expire_date');

	if( !empty($params['search']['value']) ) {
		$db->where('game_type', '%' . $params['search']['value'] . '%', 'like');
		$db->orwhere('redeem_code', '%' . $params['search']['value'] . '%', 'like');
		$db->orwhere('redeem_name', '%' . $params['search']['value'] . '%', 'like');
	}

	if( !empty($params['columns'][2]['search']['value']) ) {
		$db->having('game_type', $params['columns'][2]['search']['value']);
	}
	
	$columnsOrder = array('', 'id', 'game_type', 'redeem_code', 'redeem_name', 'redeem_total', 'redeem_type', 'expire_date');
	$db->orderBy($columnsOrder[$params['order'][0]['column']], $params['order'][0]['dir']);
	
	$limit = Array ($params['start'], $params['length']);
	if($params['length'] == -1){
		$limit = null;	
	}

	$records = $db->withTotalCount()->get($table_redeem_code, $limit, $columns);
	$totalRecords = $db->totalCount;

	foreach ($records as $row){
		$row['expire_date'] = date('d-m-Y', strtotime($row['expire_date']));
		$data[] = $row;
	}

	$json_data = array(
		"draw"            => intval( $params['draw'] ),   
		"recordsTotal"    => intval( $totalRecords ),  
		"recordsFiltered" => intval($totalRecords),
		"data"            => $data
	);

	echo json_encode($json_data);
?>
	