<?php
	// token function
	function crypto_rand_secure($min, $max)
	{
		$range = $max - $min;
		if ($range < 1) return $min; // not so random...
		$log = ceil(log($range, 2));
		$bytes = (int) ($log / 8) + 1; // length in bytes
		$bits = (int) $log + 1; // length in bits
		$filter = (int) (1 << $bits) - 1; // set all lower bits to 1
		do {
			$rnd = hexdec(bin2hex(openssl_random_pseudo_bytes($bytes)));
			$rnd = $rnd & $filter; // discard irrelevant bits
		} while ($rnd > $range);
		return $min + $rnd;
	}
	
	function getToken($length){
		$token = '';
		$codeAlphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$codeAlphabet.= 'abcdefghijklmnopqrstuvwxyz';
		$codeAlphabet.= '0123456789';
		$max = strlen($codeAlphabet); // edited
	
		for ($i=0; $i < $length; $i++) {
			$token .= $codeAlphabet[crypto_rand_secure(0, $max-1)];
		}
	
		return $token;
	}
	
	function checkExistPoints($member_id, $gameType){
		global $conn;
		global $table_points;
		
		$stmt = $conn->prepare("SELECT id, member_point, member_chance, member_score FROM $table_points WHERE member_id = ? AND game_type = ?");			
		$stmt->bind_param("ss", $member_id, $gameType);
		$stmt->execute();
		$stmt->store_result();
		$stmt -> bind_result($id, $member_point, $member_chance, $member_score);
		$users = [];
		while ($stmt->fetch()) {
			$users[] = array(
				'id' => $id,
				'member_point' => $member_point,
				'member_chance' => $member_chance,
				'member_score' => $member_score
			);
		}
    	$stmt->free_result();
		$stmt->close();

		return $users;	
	}
	
	function createMemberPoints($gameType, $member_last_id, $defaultPoint, $defaultChance, $defaultScore){
		global $conn;
		global $table_points;
		
		$stmt = $conn->prepare("INSERT INTO $table_points (game_type, member_id, member_point, member_chance, member_score) VALUES(?,?,?,?,?)");
			
		if (
			$stmt &&
			$stmt -> bind_param("sssss", $gameType, $member_last_id, $defaultPoint, $defaultChance, $defaultScore) &&
			$stmt -> execute() &&
			$stmt -> affected_rows === 1
		)
		{
			$stmt->close();
			return true;
		}else {
			return false;
		}	
	}
	
	function updateMemberPoints($member_point, $member_chance, $member_score, $member_id, $gameType){
		global $conn;
		global $table_points;
		global $global_game_points;
		
		if($global_game_points){
			$stmt = $conn->prepare("UPDATE $table_points SET member_point=?,member_chance=?,member_score=?,date_updated=NOW() WHERE member_id=?");
			
			if (
				$stmt &&
				$stmt -> bind_param("ssss", $member_point, $member_chance, $member_score, $member_id) &&
				$stmt -> execute()
			)
			{
				$stmt->close();
				return true;
			}else{
				return false;
			}
		}else{
			$stmt = $conn->prepare("UPDATE $table_points SET member_point=?,member_chance=?,member_score=?,date_updated=NOW() WHERE member_id=? AND game_type=?");
			
			if (
				$stmt &&
				$stmt -> bind_param("sssss", $member_point, $member_chance, $member_score, $member_id, $gameType) &&
				$stmt -> execute() &&
				$stmt -> affected_rows === 1
			)
			{
				$stmt->close();
				return true;
			}else{
				return false;
			}	
		}
	}

	function createGameLogs($gameType, $member_id, $log){
		global $conn;
		global $game_logs;
		
		$stmt = $conn->prepare("INSERT INTO $game_logs (game_type, member_id, game_data) VALUES(?,?,?)");
			
		if (
			$stmt &&
			$stmt -> bind_param("sss", $gameType, $member_id, $log) &&
			$stmt -> execute() &&
			$stmt -> affected_rows === 1
		)
		{
			$stmt->close();
			return true;
		}else {
			return false;
		}	
	}
?>