<?php
include 'dbconn.php';
include 'func.php';

if($testMode){
	echo '{"status":true}';
	exit;
}

// Only process POST reqeusts.
if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_REQUEST['member_email'])) {
		$member_email = mysqli_real_escape_string($conn, $_REQUEST['member_email']);
		
		$stmt = $conn->prepare("SELECT id FROM $table_member WHERE member_email = ?");
		$stmt->bind_param("s", $member_email);
		$stmt->execute();
		$stmt->store_result();
		$num_of_rows = $stmt->num_rows;
		$stmt->free_result();
		$stmt->close();
		
		if($num_of_rows > 0){			
			// Get the form fields and remove whitespace.
			$member_email = filter_var(trim($_POST['member_email']), FILTER_SANITIZE_EMAIL);
	
			// Check that data was sent to the mailer.
			if (!filter_var($member_email, FILTER_VALIDATE_EMAIL)) {
				// Set a 400 (bad request) response code and exit.
				http_response_code(400);
				echo '{"status":false, "message":"'.$lang['server-password-reset-try-error'].'"}';
				exit;
			}
			
			$reset_token = md5($member_email.date('Y-m-d H:i:s'));
			$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]';
			$actual_link = str_replace('memberrewards/m_email.php','',$actual_link).'?reset='.$reset_token;
			
			
			$stmt = $conn->prepare("UPDATE $table_member SET reset_token=? WHERE member_email=?");
			
			if (
				$stmt &&
				$stmt -> bind_param("ss", $reset_token, $member_email) &&
				$stmt -> execute() &&
				$stmt -> affected_rows === 1
			)
			{
				$stmt->close();
				
				// Set the recipient email address.
				// FIXME: Update this to your desired email address.
				$recipient = $member_email;
		
				// Set the email subject.
				$subject = $email_subject;
		
				// Build the email content.
				$email_content = "<html>";
				$email_content .= "<body>";
				$email_content .= $lang['server-password-reset-content']."<br/><a href='$actual_link'>$actual_link</a>";
				$email_content .= "</body>";
				$email_content .= "</html>";
		
				// Build the email headers.
				$email_headers = "From: ".$email_from."\r\n";
				$email_headers .= "MIME-Version: 1.0" . "\r\n";
				$email_headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
		
				// Send the email.
				if (mail($recipient, $subject, $email_content, $email_headers)) {
					// Set a 200 (okay) response code.
					echo '{"status":true}';
					http_response_code(200);
				} else {
					// Set a 500 (internal server error) response code.
					echo '{"status":false, "message":"'.$lang['server-password-reset-cannot-send'].'"}';
					http_response_code(500);
				}
			}else{
				echo '{"status":false, "message":"'.$lang['server-password-reset-error'].'"}';	
			}
		}else{
			echo '{"status":false, "message":"'.$lang['server-password-reset-no-email'].'"}';
		}
} else {
	// Not a POST request, set a 403 (forbidden) response code.
	echo '{"status":false, "message":"'.$lang['server-password-reset-error'].'"}';
	http_response_code(403);
}

?>