<?php
include 'dbconn.php';
include 'func.php';

if(!empty($_REQUEST['type']))
{
	$type = mysqli_real_escape_string($conn, $_REQUEST['type']);
	$proceed = false;
	
	if($type == 'fb' && !empty($_REQUEST['fb_id'])){
		$proceed = true;
	}
	
	if($proceed){
		$member_name = mysqli_real_escape_string($conn, $_REQUEST['name']);
		$fb_id = mysqli_real_escape_string($conn, $_REQUEST['fb_id']);
		
		$stmt = $conn->prepare("SELECT id, active_status FROM $table_member WHERE fb_id = ?");
		$stmt->bind_param("s", $fb_id);
		$stmt->execute();
		$stmt->store_result();
		$num_of_rows = $stmt->num_rows;
		$stmt -> bind_result($id, $active_status);
		
		$users = [];
		while ($stmt->fetch()) {
			$users[] = array(
				'id' => $id,
				'active_status' => $active_status
			);
		}
    	$stmt->free_result();
		$stmt->close();
		
		$proceedCreatePoint = false;
		$userActive = false;
		$proceedComplete = false;
		
		if($num_of_rows > 0){
			//exisitng user
			$member_id = $users[0]['id'];
			$active_status = $users[0]['active_status'];
			
			if((int)$active_status == 1){
				$userActive = true;	
				
				$check_member_points = checkExistPoints($member_id, $gameType);
				if(count($check_member_points) > 0){
					$proceedComplete = true;
				}else{
					$proceedCreatePoint = true;
				}
			}
		} else {
			$stmt = $conn->prepare("INSERT INTO $table_member (member_name, fb_id) VALUES(?, ?)");
			
			if (
				$stmt &&
				$stmt -> bind_param("ss", $member_name, $fb_id) &&
				$stmt -> execute() &&
				$stmt -> affected_rows === 1
			){
				$stmt->close();
				$member_id = $conn->insert_id;
				$proceedCreatePoint = true;
				$userActive = true;
			}
		 }
		 
		 if($proceedCreatePoint){
			if(createMemberPoints($gameType, $member_id, $defaultPoint, $defaultChance, $defaultScore)){
				$proceedComplete = true;
			} 
		 }
		 
		 if(!$userActive){
			echo '{"status":false, "message":"This account is not active."}';
		 }else if($proceedComplete){
			$check_member_points = checkExistPoints($member_id, $gameType);
			if(count($check_member_points) > 0){
				$member_point = $check_member_points[0]['member_point'];
				$member_chance = $check_member_points[0]['member_chance'];
				$member_score = $check_member_points[0]['member_score'];
				
				$_SESSION['Facebook_ID'] = $fb_id;
				$_SESSION['Member_ID'] = $member_id;
				$_SESSION['Name'] = $member_name;
				$_SESSION['Email'] = '';
				$_SESSION['Type'] = 'fb';
				$_SESSION['LoggedIn'.$session_app] = 1;
				$_SESSION['Token'] = getToken(30);

				echo '{"status":true, "member_id":'.$member_id.', "member_name":"'.$member_name.'", "member_point":'.$member_point.', "member_chance":'.$member_chance.', "member_score":'.$member_score.', "token":"'.$_SESSION['Token'].'", "game_type":"'.$gameType.'", "message":"'.$lang['user-login-successful'].'"}';	
			}else{
				echo '{"status":false, "message":"'.$lang['server-points-not-found'].'"}';	
			}
		}else{
			echo '{"status":false, "message":"'.$lang['server-points-not-found'].'"}';
		}
	}else{
		echo '{"status":false, "message":"'.$lang['server-error'].'"}';
	}
	
}else{
	echo '{"status":false, "message":"'.$lang['server-error'].'"}';	
}

// Close connection
mysqli_close($conn);
?>