<?php
include 'dbconn.php';
include 'func.php';

if (!isset($_SESSION['LoggedIn'.$session_app])) {
	echo '{"status":false, "message":"'.$lang['session-timeout'].'", "session":false}';	
	exit();
}

$data = array('order_id','order_name','order_price');
$data_length = count($data);

$stmt = $conn->prepare("SELECT order_id, order_name, order_price FROM $table_products WHERE game_type = ?");
$stmt->bind_param("s", $gameType);
$stmt->execute();
$stmt->store_result();
$num_of_rows = $stmt->num_rows;
$stmt -> bind_result($order_id, $order_name, $order_price);
$array = [];
while ($stmt->fetch()) {
	$array[] = array(
		'order_id' => $order_id,
		'order_name' => $order_name,
		'order_price' => $order_price
	);
}
$stmt->free_result();
$stmt->close();

$top_data = '';

for($i = 0; $i < $num_of_rows; $i++)
{
	$comma = ',';
	if($i == ($num_of_rows-1)){
		$comma = '';	
	}
	
	$table_val = '';
	for($c = 0; $c < $data_length; $c++){
		$commaInner = ',';
		if($c == ($data_length-1)){
			$commaInner = '';	
		}
		$table_val .= '"'.$data[$c].'":"'.$array[$i][$data[$c]].'"'.$commaInner;
	}
	$top_data .= '{ '.$table_val.' }'.$comma;
}

if($num_of_rows > 0){
	echo '{"status":true, "datas":['.$top_data.']}';
}else{
	echo '{"status":false}';
}
	
?>