<?php
include 'dbconn.php';
include 'func.php';

if (!isset($_SESSION['LoggedIn'.$session_app])) {
	echo '{"status":false, "message":"'.$lang['session-timeout'].'", "session":false}';	
	exit();
}

$data = array('id','reward_name','reward_image','reward_points');
$data_length = count($data);

$stmt = $conn->prepare("SELECT id, reward_name, reward_image, reward_points FROM $table_rewards WHERE game_type = ?");
$stmt->bind_param("s", $gameType);
$stmt->execute();
$stmt->store_result();
$num_of_rows = $stmt->num_rows;
$stmt -> bind_result($id, $reward_name, $reward_image, $reward_points);
$array = [];
while ($stmt->fetch()) {
	$array[] = array(
		'id' => $id,
		'reward_name' => $reward_name,
		'reward_image' => $reward_image,
		'reward_points' => $reward_points
	);
}
$stmt->free_result();
$stmt->close();
$top_data = '';

for($i = 0; $i < $num_of_rows; $i++)
{
	$comma = ',';
	if($i == ($num_of_rows-1)){
		$comma = '';	
	}
	
	$table_val = '';
	for($c = 0; $c < $data_length; $c++){
		$commaInner = ',';
		if($c == ($data_length-1)){
			$commaInner = '';	
		}
		if($data[$c] == 'reward_image'){
			$table_val .= '"'.$data[$c].'":"'.$rewards_upload_path.$array[$i][$data[$c]].'"'.$commaInner;
		}else{
			$table_val .= '"'.$data[$c].'":"'.$array[$i][$data[$c]].'"'.$commaInner;
		}
	}
	$top_data .= '{ '.$table_val.' }'.$comma;
}

if($num_of_rows > 0){
	echo '{"status":true, "datas":['.$top_data.']}';
}else{
	echo '{"status":false}';
}
	
?>