<?php
include 'dbconn.php';
include 'func.php';

if (!isset($_SESSION['LoggedIn'.$session_app])) {
	echo '{"status":false, "message":"'.$lang['session-timeout'].'", "session":false}';	
	exit();
}

if(!empty($_SESSION['LoggedIn'.$session_app]) && !empty($_SESSION['Type']) && !empty($_REQUEST['token']))
{
	$token = mysqli_real_escape_string($conn, $_REQUEST['token']);
	if ($token == $_SESSION['Token']){
		//if token match		
		$stmt = $conn->prepare("SELECT member_point, member_chance, member_score FROM $table_points WHERE member_id = ? AND game_type = ?");
		$stmt->bind_param("ss", $_SESSION['Member_ID'], $gameType);
		$stmt->execute();
		$stmt->store_result();
		$num_of_rows = $stmt->num_rows;
		$stmt -> bind_result($member_point, $member_chance, $member_score);
		
		$users = [];
		while ($stmt->fetch()) {
			$users[] = array(
				'member_point' => $member_point,
				'member_chance' => $member_chance,
				'member_score' => $member_score
			);
		}
    	$stmt->free_result();
		$stmt->close();
			
		if($num_of_rows > 0)
		{
			$member_point = $users[0]['member_point'];
			$member_chance = $users[0]['member_chance'];
			$member_score = $users[0]['member_score'];
			$_SESSION['Token'] = getToken(30);
			
			echo '{"status":true, "member_point":'.$member_point.', "member_chance":'.$member_chance.', "member_score":'.$member_score.', "token":"'.$_SESSION['Token'].'"}';
		}else{
			echo '{"status":false, "message":"'.$lang['server-points-not-found'].'"}';	
		}
	}else{
		echo '{"status":false, "message":"'.$lang['server-error-undefined-token'].'"}';	
	}
}else{
	echo '{"status":false, "message":"'.$lang['server-error'].'"}';
}

// Close connection
mysqli_close($conn);
?>