<?php
include 'dbconn.php';
include 'func.php';

if (!isset($_SESSION['LoggedIn'.$session_app])) {
	echo '{"status":false, "message":"'.$lang['session-timeout'].'", "session":false}';	
	exit();
}

if($testMode){
	echo '{"status":true}';
	exit;
}

if(!empty($_REQUEST['reward_id']) && !empty($_REQUEST['token']))
{
	$token = mysqli_real_escape_string($conn, $_REQUEST['token']);
	if ($token == $_SESSION['Token']){
		//if token match
		$reward_id = mysqli_real_escape_string($conn, $_REQUEST['reward_id']);
		
		//exit user
		$check_member_points = checkExistPoints($_SESSION['Member_ID'], $gameType);
		if(count($check_member_points) > 0){
			$update_member_point = $check_member_points[0]['member_point'];
			$update_member_chance = $check_member_points[0]['member_chance'];
			$update_member_score = $check_member_points[0]['member_score'];
		}
		
		//exit redeem		
		$stmt = $conn->prepare("SELECT reward_points, reward_type, reward_for_points, reward_for_chances FROM $table_rewards WHERE id = ?");
		$stmt->bind_param("s", $reward_id);
		$stmt->execute();
		$stmt->store_result();
		$num_of_rows = $stmt->num_rows;
		$stmt -> bind_result($reward_points, $reward_type, $reward_for_points, $reward_for_chances);
		
		$array = [];
		while ($stmt->fetch()) {
			$array[] = array(
				'reward_points' => $reward_points,
				'reward_type' => $reward_type,
				'reward_for_points' => $reward_for_points,
				'reward_for_chances' => $reward_for_chances
			);
		}
    	$stmt->free_result();
		$stmt->close();
		
		if($num_of_rows > 0){
			$reward_points = (int)$array[0]['reward_points'];
			$reward_type = (int)$array[0]['reward_type'];
			$reward_for_points = (int)$array[0]['reward_for_points'];
			$reward_for_chances = (int)$array[0]['reward_for_chances'];
			
			$redeem_status = 0;
			if($reward_type == 1){
				$redeem_status = 2;
			}
		}
		
		if($reward_points && $update_member_point){
			$update_member_point -= $reward_points;
			
			if($redeem_status == 2){
				$update_member_chance += $reward_for_chances;
			}
			
			
			$stmt = $conn->prepare("INSERT INTO $table_redemption (game_type, member_id, reward_id, redeem_status) VALUES(?, ?, ?, ?)");
			
			if (
				$stmt &&
				$stmt -> bind_param("ssss", $gameType, $_SESSION['Member_ID'], $reward_id, $redeem_status) &&
				$stmt -> execute() &&
				$stmt -> affected_rows === 1
			)
			{
				$stmt->close();
				if(updateMemberPoints($update_member_point, $update_member_chance, $update_member_score, $_SESSION['Member_ID'], $gameType)){
					$_SESSION['Token'] = getToken(30);
					echo '{"status":true, "token":"'.$_SESSION['Token'].'", "member_point":'.$update_member_point.', "member_chance":'.$update_member_chance.', "member_score":'.$update_member_score.', "message":"Redeem updated successful."}';
				}else{
					echo '{"status":false, "message":"'.$lang['server-redeem-error'].'"}';
				}
			}else{
				echo '{"status":false, "message":"'.$lang['server-redeem-error'].'"}';	
			}
		}else{
			echo '{"status":false, "message":"'.$lang['server-redeem-not-found'].'"}';
		}
	}else{
		echo '{"status":false, "message":"'.$lang['server-error-undefined-token'].'"}';	
	}
}else{
	echo '{"status":false, "message":"'.$lang['server-error'].'"}';	
}

// Close connection
mysqli_close($conn);
?>