<?php
include 'dbconn.php';
include 'func.php';

if($testMode){
	echo '{"status":true, "message":"'.$lang['user-singup-successful'].'"}';
	exit;
}

if(!empty($_REQUEST['type']))
{
	$type = mysqli_real_escape_string($conn, $_REQUEST['type']);
	$proceed = false;
	
	if(!empty($_REQUEST['name']) && !empty($_REQUEST['password']) && !empty($_REQUEST['email']) ){
		$proceed = true;
	}
	
	if($proceed){
		$member_name = mysqli_real_escape_string($conn, $_REQUEST['name']);
		$member_email = mysqli_real_escape_string($conn, $_REQUEST['email']);
		$member_password = mysqli_real_escape_string($conn, $_REQUEST['password']);
		$member_password = md5($member_password);
		
		$stmt = $conn->prepare("SELECT id FROM $table_member WHERE member_email = ?");
		$stmt->bind_param("s", $member_email);
		$stmt->execute();
		$stmt->store_result();
		$num_of_rows = $stmt->num_rows;
		$stmt->free_result();
		$stmt->close();
		
		if($num_of_rows > 0)
		 {
			echo '{"status":false, "message":"'.$lang['user-registered'].'"}';
		 } else {
			$stmt = $conn->prepare("INSERT INTO $table_member (member_name, member_password, member_email) VALUES(?, ?, ?)");
			
			if (
				$stmt &&
				$stmt -> bind_param("sss", $member_name, $member_password, $member_email) &&
				$stmt -> execute() &&
				$stmt -> affected_rows === 1
			)
			{
				$member_last_id = $conn->insert_id;
				$stmt->close();
				
				if(createMemberPoints($gameType, $member_last_id, $defaultPoint, $defaultChance, $defaultScore)){
					echo '{"status":true, "message":"'.$lang['user-singup-successful'].'"}';
				}else {
					echo '{"status":false, "message":"'.$lang['server-error'].'"}';    
				}
			}else {
				echo '{"status":false, "message":"'.$lang['server-error'].'"}';    
			}
		 }
	}else{
		echo '{"status":false, "message":"'.$lang['server-error'].'"}';
	}
	
}else{
	echo '{"status":false, "message":"'.$lang['server-error'].'"}';	
}

// Close connection
mysqli_close($conn);
?>