<?php
include 'dbconn.php';
include 'func.php';

if($testMode){
	echo '{"status":true, "message":"'.$lang['server-password-update-successful'].'"}';
	exit;
}

if(!empty($_REQUEST['reset_token']) && !empty($_REQUEST['member_password']) )
{
	$reset_token = mysqli_real_escape_string($conn, $_REQUEST['reset_token']);
	$member_password = mysqli_real_escape_string($conn, $_REQUEST['member_password']);
	$member_password = md5($member_password);
	
	$stmt = $conn->prepare("SELECT id FROM $table_member WHERE reset_token = ?");
	$stmt->bind_param("s", $reset_token);
	$stmt->execute();
	$stmt->store_result();
	$num_of_rows = $stmt->num_rows;
	$stmt -> bind_result($id);
	$users = [];
	while ($stmt->fetch()) {
		$users[] = array(
			'id' => $id
		);
	}
	$stmt->free_result();
	$stmt->close();
	
	if($num_of_rows > 0)
	 {
		 //existing user
		$member_id = $users[0]['id'];
		$stmt = $conn->prepare("UPDATE $table_member SET member_password = ? WHERE reset_token = ?");
		
		if (
			$stmt &&
			$stmt -> bind_param("ss", $member_password, $reset_token) &&
			$stmt -> execute()
		)
		{
			$stmt->close();
			
			$stmt = $conn->prepare("UPDATE $table_member SET reset_token='' WHERE id=?");
			
			$stmt->bind_param("s", $member_id);
			$stmt->execute();
			$stmt->close();
			
			echo '{"status":true, "message":"'.$lang['server-password-update-successful'].'"}';
		}else {
			echo '{"status":false, "message":"'.$lang['server-password-update-failed'].'"}';	
		 }
	}else{
		echo '{"status":false, "message":"'.$lang['server-error'].'"}';
	}
}else{
	echo '{"status":false, "message":"'.$lang['server-error'].'"}';	
}

// Close connection
mysqli_close($conn);
?>