<?php
include 'dbconn.php';
include 'func.php';

if (!isset($_SESSION['LoggedIn'.$session_app])) {
	echo '{"status":false, "message":"'.$lang['session-timeout'].'", "session":false}';	
	exit();
}

if(!empty($_REQUEST['type']) && !empty($_REQUEST['order_id']) && !empty($_REQUEST['token']))
{
	$token = mysqli_real_escape_string($conn, $_REQUEST['token']);
	if ($token == $_SESSION['Token']){
		//if token match
		$type = mysqli_real_escape_string($conn, $_REQUEST['type']);
		$order_id = mysqli_real_escape_string($conn, $_REQUEST['order_id']);
		
		if( $type == 'create'){
			//create
			$stmt = $conn->prepare("INSERT INTO $table_transaction (game_type, member_id, order_id, payment_status) VALUES(?, ?, ?, 0)");

			if (
					$stmt &&
					$stmt->bind_param("sss", $gameType, $_SESSION['Member_ID'], $order_id) &&
					$stmt -> execute() &&
					$stmt -> affected_rows === 1
				)
			{
				$stmt->close();
				$order_created_id = $conn->insert_id;
				$_SESSION['Token'] = getToken(30);
				
				echo '{"status":true, "message":"'.$lang['server-success'].'.", "token":"'.$_SESSION['Token'].'", "order_created_id":'.$order_created_id.'}';
			}else{
				echo '{"status":false, "message":"'.$lang['server-transaction-error'].'"}';		
			}
		}else if( $type == 'update'){
			//update
			if(!empty($_REQUEST['payment_id']) && !empty($_REQUEST['order_created_id']))
			{
				$payment_id = mysqli_real_escape_string($conn, $_REQUEST['payment_id']);
				$order_created_id = mysqli_real_escape_string($conn, $_REQUEST['order_created_id']);
				
				$stmt = $conn->prepare("UPDATE $table_transaction SET payment_status=1,payment_id=? WHERE id=?");
			
				if (
					$stmt &&
					$stmt -> bind_param("ss", $payment_id, $order_created_id) &&
					$stmt -> execute() &&
					$stmt -> affected_rows === 1
				)
				{
					$stmt->close();
					
					//find product					
					$stmt = $conn->prepare("SELECT order_points, order_chances FROM $table_products WHERE order_id = ? AND game_type = ?");
					$stmt->bind_param("ss", $order_id, $gameType);
					$stmt->execute();
					$stmt->store_result();
					$num_of_rows = $stmt->num_rows;
					$stmt -> bind_result($order_points, $order_chances);

					$users = [];
					while ($stmt->fetch()) {
						$users[] = array(
							'order_points' => $order_points,
							'order_chances' => $order_chances
						);
					}
					$stmt->free_result();
					$stmt->close();
					
					if($num_of_rows > 0){
						$order_points = (int)$users[0]['order_points'];
						$order_chances = (int)$users[0]['order_chances'];
						
						//find member points
						$check_member_points = checkExistPoints($_SESSION['Member_ID'], $gameType);
						if(count($check_member_points) > 0){
							$point_id = $check_member_points[0]['id'];
							$update_member_point = (int)$check_member_points[0]['member_point'];
							$update_member_chance = (int)$check_member_points[0]['member_chance'];
							$update_member_score = (int)$check_member_points[0]['member_score'];
							
							$update_member_point += $order_points;
							$update_member_chance += $order_chances;
							
							if(updateMemberPoints($update_member_point, $update_member_chance, $update_member_score, $_SESSION['Member_ID'], $gameType)){
								$_SESSION['Token'] = getToken(30);
								echo '{"status":true, "message":"'.$lang['server-success'].'", "token":"'.$_SESSION['Token'].'"}';	
							}else{
								echo '{"status":false, "message":"'.$lang['server-points-failed'].'"}';
							}
						}else{
							echo '{"status":false, "message":"'.$lang['server-points-failed'].'"}';
						}
					}else{
						echo '{"status":false, "message":"'.$lang['server-points-failed'].'"}';
					}
				}else{
					echo '{"status":false, "message":"'.$lang['server-transaction-error'].'"}';
				}	
			}else{
				echo '{"status":false, "message":"'.$lang['server-transaction-error'].'"}';
			}
		}else{
			echo '{"status":false, "message":"'.$lang['server-error'].'"}';
		}
	}else{
		echo '{"status":false, "message":"'.$lang['server-error-undefined-token'].'"}';
	}
}else{
	echo '{"status":false, "message":"'.$lang['server-error'].'"}';	
}

// Close connection
mysqli_close($conn);
?>